/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Leash entities")
@Description(value={"Leash living entities to other entities."})
@Examples(value={"leash the player to the target entity"})
@Since(value="2.3")
public class EffLeash
extends Effect {
    private Expression<Entity> holder;
    private Expression<LivingEntity> targets;
    private boolean leash;

    static {
        Skript.registerEffect(EffLeash.class, "(leash|lead) %livingentities% to %entity%", "make %entity% (leash|lead) %livingentities%", "un(leash|lead) [holder of] %livingentities%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean bl = this.leash = matchedPattern != 2;
        if (this.leash) {
            this.holder = exprs[1 - matchedPattern];
            this.targets = exprs[matchedPattern];
        } else {
            this.targets = exprs[0];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.leash) {
            Entity holder = this.holder.getSingle(e);
            if (holder == null) {
                return;
            }
            LivingEntity[] livingEntityArray = this.targets.getArray(e);
            int n = livingEntityArray.length;
            int n2 = 0;
            while (n2 < n) {
                LivingEntity target = livingEntityArray[n2];
                target.setLeashHolder(holder);
                ++n2;
            }
        } else {
            LivingEntity[] livingEntityArray = this.targets.getArray(e);
            int n = livingEntityArray.length;
            int n3 = 0;
            while (n3 < n) {
                LivingEntity target = livingEntityArray[n3];
                target.setLeashHolder(null);
                ++n3;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.leash) {
            return "leash " + this.targets.toString(e, debug) + " to " + this.holder.toString(e, debug);
        }
        return "unleash " + this.targets.toString(e, debug);
    }
}

