/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config.validate;

import ch.njol.skript.Skript;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.validate.EntryValidator;
import ch.njol.util.Setter;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;

public class EnumEntryValidator<E extends Enum<E>>
extends EntryValidator {
    private final Class<E> enumType;
    private final Setter<E> setter;
    @Nullable
    private String allowedValues = null;

    public EnumEntryValidator(Class<E> enumType, Setter<E> setter) {
        assert (enumType != null);
        this.enumType = enumType;
        this.setter = setter;
        if (((Enum[])enumType.getEnumConstants()).length <= 12) {
            StringBuilder b = new StringBuilder(((Enum[])enumType.getEnumConstants())[0].name());
            Enum[] enumArray = (Enum[])enumType.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(e.name());
                ++n2;
            }
            this.allowedValues = b.toString();
        }
    }

    public EnumEntryValidator(Class<E> enumType, Setter<E> setter, String allowedValues) {
        assert (enumType != null);
        this.enumType = enumType;
        this.setter = setter;
        this.allowedValues = allowedValues;
    }

    @Override
    public boolean validate(Node node) {
        if (!super.validate(node)) {
            return false;
        }
        EntryNode n = (EntryNode)node;
        try {
            E e = Enum.valueOf(this.enumType, n.getValue().toUpperCase(Locale.ENGLISH).replace(' ', '_'));
            assert (e != null);
            this.setter.set(e);
        }
        catch (IllegalArgumentException e) {
            Skript.error("'" + n.getValue() + "' is not a valid value for '" + n.getKey() + "'" + (this.allowedValues == null ? "" : ". Allowed values are: " + this.allowedValues));
            return false;
        }
        return true;
    }
}

