/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Resource Pack")
@Description(value={"Checks state of the resource pack in a <a href='events.html#resource_pack_request_action'>resource pack request response</a> event."})
@Examples(value={"on resource pack response:", "\tif the resource pack wasn't accepted:", "\t\tkick the player due to \"You have to install the resource pack to play in this server!\""})
@Since(value="2.4")
@Events(value={"resource pack request response"})
public class CondResourcePack
extends Condition {
    private Expression<PlayerResourcePackStatusEvent.Status> states;

    static {
        Skript.registerCondition(CondResourcePack.class, "[the] resource pack (was|is|has) [been] %resourcepackstate%", "[the] resource pack (was|is|has)(n't| not) [been] %resourcepackstate%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(PlayerResourcePackStatusEvent.class)) {
            Skript.error("The resource pack condition can't be used outside of a resource pack response event");
            return false;
        }
        this.states = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        PlayerResourcePackStatusEvent.Status state = ((PlayerResourcePackStatusEvent)e).getStatus();
        return this.states.check(e, arg_0 -> state.equals(arg_0), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "resource pack was " + (this.isNegated() ? "not " : "") + this.states.toString(e, debug);
    }
}

