/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClickEventTracker {
    final Map<UUID, TrackedEvent> firstEvents = new HashMap<UUID, TrackedEvent>();

    public ClickEventTracker(JavaPlugin plugin) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> this.firstEvents.clear(), 1L, 1L);
    }

    public boolean checkEvent(Player player, Cancellable event, EquipmentSlot hand) {
        UUID uuid = player.getUniqueId();
        TrackedEvent first = this.firstEvents.get(uuid);
        if (first != null && first.event != event) {
            if (hand == EquipmentSlot.HAND && first.hand == EquipmentSlot.OFF_HAND || hand == EquipmentSlot.OFF_HAND && first.hand == EquipmentSlot.HAND) {
                this.firstEvents.remove(uuid);
            }
            event.setCancelled(first.event.isCancelled());
            return false;
        }
        this.firstEvents.put(uuid, new TrackedEvent(event, hand));
        return true;
    }

    private static class TrackedEvent {
        final Cancellable event;
        final EquipmentSlot hand;

        public TrackedEvent(Cancellable event, EquipmentSlot hand) {
            this.event = event;
            this.hand = hand;
        }
    }
}

