/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Vector from Location")
@Description(value={"Creates a vector from a location."})
@Examples(value={"set {_v} to vector of {_loc}"})
@Since(value="2.2-dev28")
public class ExprVectorOfLocation
extends SimpleExpression<Vector> {
    private Expression<Location> location;

    static {
        Skript.registerExpression(ExprVectorOfLocation.class, Vector.class, ExpressionType.SIMPLE, "[the] vector (of|from|to) %location%", "%location%'s vector");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = exprs[0];
        return true;
    }

    protected Vector[] get(Event e) {
        Location l = this.location.getSingle(e);
        if (l == null) {
            return null;
        }
        return CollectionUtils.array(l.toVector());
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "vector from " + this.location.toString(e, debug);
    }
}

