/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Map;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Indexes of List")
@Description(value={"Returns all the indexes of a list variable"})
@Examples(value={"set {l::*} to \"some\", \"cool\" and \"values\"\nbroadcast \"%all indexes of {l::*}%\" # result is 1, 2 and 3"})
@Since(value="2.4")
public class ExprIndices
extends SimpleExpression<String> {
    private Variable<?> list;

    static {
        Skript.registerExpression(ExprIndices.class, String.class, ExpressionType.COMBINED, "[the] (indexes|indices) of %objects%", "(all of the|all the|all) (indices|indexes) of %objects%");
    }

    @Nullable
    protected String[] get(Event e) {
        Map valueMap = (Map)this.list.getRaw(e);
        if (valueMap == null) {
            return null;
        }
        return valueMap.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "all indexes of " + this.list.toString(null, debug);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (exprs[0] instanceof Variable && ((Variable)exprs[0]).isList()) {
            this.list = (Variable)exprs[0];
            return true;
        }
        if (!(exprs[0] instanceof UnparsedLiteral)) {
            Skript.error("The indexes expression may only be used with list variables");
        }
        return false;
    }
}

