/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtLevel
extends SkriptEvent {
    private Kleenean leveling;

    static {
        Skript.registerEvent("Level Change", EvtLevel.class, PlayerLevelChangeEvent.class, "[player] level (change|1\u00a6up|-1\u00a6down)").description("Called when a player's <a href='expressions.html#ExprLevel'>level</a> changes, e.g. by gathering experience or by enchanting something.").examples("on level change:").since("1.0, 2.4 (level up/down)");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.leveling = Kleenean.get(parseResult.mark);
        return true;
    }

    @Override
    public boolean check(Event e) {
        PlayerLevelChangeEvent event = (PlayerLevelChangeEvent)e;
        if (this.leveling.isTrue()) {
            return event.getNewLevel() > event.getOldLevel();
        }
        if (this.leveling.isFalse()) {
            return event.getNewLevel() < event.getOldLevel();
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "level " + (this.leveling.isTrue() ? "up" : (this.leveling.isFalse() ? "down" : "change"));
    }
}

