/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.WeatherEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Weather")
@Description(value={"Checks whether the weather in a world is of a specific type.", "<i>I welcome any ideas how to write this condition differently.</i>"})
@Examples(value={"is thundering", "is raining in \"world\" or \"world2\""})
@Since(value="1.0")
public class CondWeather
extends Condition {
    private Expression<WeatherType> weathers;
    private Expression<World> worlds;

    static {
        Skript.registerCondition(CondWeather.class, "is %weathertypes% [in %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.weathers = vars[0];
        this.worlds = vars[1];
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.worlds.check(e, w -> {
            WeatherType weatherType = e instanceof WeatherEvent && w.equals(((WeatherEvent)e).getWorld()) && !Delay.isDelayed(e) ? WeatherType.fromEvent((WeatherEvent)e) : WeatherType.fromWorld(w);
            return this.weathers.check(e, expectedType -> expectedType == weatherType);
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "is " + this.weathers.toString(e, debug) + " in " + this.worlds.toString(e, debug);
    }
}

