/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.registrations.Comparators;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Contains")
@Description(value={"Checks whether an inventory contains an item, a text contains another piece of text, or a list (e.g. {list variable::*} or 'drops') contains another object."})
@Examples(value={"block contains 20 cobblestone", "player has 4 flint and 2 iron ingots", "{list::*} contains 5"})
@Since(value="1.0")
public class CondContains
extends Condition {
    private Expression<?> containers;
    private Expression<?> items;
    private boolean isListCheck;
    private boolean isStringCheck;
    private boolean isAnyNoneOf;

    static {
        Skript.registerCondition(CondContains.class, "%inventories% (has|have) %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories% (doesn't|does not|do not|don't) have %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings/objects% contain[s] %itemtypes/strings/objects%", "%inventories/strings/objects% (doesn't|does not|do not|don't) contain %itemtypes/strings/objects%", "[the] list [of] %objects% (doesn't|does not|do not|don't) contain %objects%", "[the] list [of] %objects% contain[s] %objects%", "(all|1\u00a6any|2\u00a6none) of %strings% contain[s] %strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.containers = exprs[0];
        this.items = exprs[1];
        this.isAnyNoneOf = parseResult.mark == 1 || parseResult.mark == 2;
        this.isListCheck = matchedPattern == 4 || matchedPattern == 5;
        boolean bl = this.isStringCheck = matchedPattern == 6;
        if (!this.isListCheck && !(this.containers instanceof Variable) && this.containers.getReturnType() != Inventory.class && this.containers.getReturnType() != String.class && this.containers.getReturnType() != Object.class) {
            Expression converted = this.containers.getConvertedExpression(Inventory.class);
            if (converted == null) {
                converted = this.containers.getConvertedExpression(String.class);
            }
            if (converted != null) {
                this.containers = converted;
            }
        }
        this.setNegated(matchedPattern == 1 || matchedPattern == 3 || matchedPattern == 4 || parseResult.mark == 2);
        return true;
    }

    @Override
    public boolean check(Event e) {
        int n;
        if (!this.isListCheck && !this.isStringCheck) {
            if (this.containers instanceof ExpressionList) {
                Expression<T>[] expressionArray = ((ExpressionList)this.containers).getExpressions();
                n = expressionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression expr = expressionArray[n2];
                    Class returnType = expr.getReturnType();
                    if (returnType != Inventory.class && returnType != String.class && returnType != Object.class) {
                        this.isListCheck = true;
                        break;
                    }
                    ++n2;
                }
            } else if (this.containers.getReturnType() != Inventory.class && this.containers.getReturnType() != String.class && !this.containers.isSingle()) {
                this.isListCheck = true;
            }
        }
        if (this.isListCheck) {
            ?[] containersAll = this.containers.getAll(e);
            if (containersAll.length == 0) {
                return this.isNegated();
            }
            return this.items.check(e, item -> {
                ?[] objArray = this.containers.getAll(e);
                int n = objArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object container = objArray[n2];
                    if (Comparator.Relation.EQUAL.is(Comparators.compare(container, item))) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }, this.isNegated());
        }
        boolean caseSensitive = SkriptConfig.caseSensitive.value();
        if (this.isAnyNoneOf) {
            ?[] objArray = this.containers.getAll(e);
            int n3 = objArray.length;
            n = 0;
            while (n < n3) {
                Object container2 = objArray[n];
                String str = (String)container2;
                assert (str != null);
                if (this.items.check(e, type -> type instanceof String && StringUtils.contains(str, (String)type, caseSensitive))) {
                    return !this.isNegated();
                }
                ++n;
            }
            return this.isNegated();
        }
        return this.containers.check(e, container -> {
            if (container instanceof Inventory) {
                Inventory inv = (Inventory)container;
                return this.items.check(e, type -> {
                    if (type instanceof ItemType) {
                        return ((ItemType)type).isContainedIn((Iterable<ItemStack>)inv);
                    }
                    if (type instanceof ItemStack) {
                        return inv.contains((ItemStack)type);
                    }
                    return false;
                });
            }
            if (container instanceof String) {
                String str = (String)container;
                return this.items.check(e, type -> type instanceof String && StringUtils.contains(str, (String)type, caseSensitive));
            }
            return false;
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.containers.toString(e, debug)) + (this.isNegated() ? " doesn't contain " : " contains ") + this.items.toString(e, debug);
    }
}

