/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.MatchQuality;
import ch.njol.skript.aliases.MaterialRegistry;
import ch.njol.skript.bukkitutil.BukkitUnsafe;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockValues;
import ch.njol.skript.localization.Message;
import ch.njol.skript.variables.Variables;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilSerializable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.eclipse.jdt.annotation.Nullable;

public class ItemData
implements Cloneable,
YggdrasilSerializable.YggdrasilExtendedSerializable {
    static final ItemFactory itemFactory;
    static final MaterialRegistry materialRegistry;
    private static final Message m_named;
    private static final boolean itemDataValues;
    transient ItemStack stack;
    transient Material type;
    boolean isAnything;
    @Nullable
    transient BlockValues blockValues;
    boolean itemForm;
    boolean isAlias = false;
    int itemFlags;

    static {
        String content;
        Variables.yggdrasil.registerSingleClass(ItemData.class, "NewItemData");
        Variables.yggdrasil.registerSingleClass(OldItemData.class, "ItemData");
        itemFactory = Bukkit.getServer().getItemFactory();
        Gson gson = new GsonBuilder().serializeNulls().create();
        Path materialsFile = Paths.get(Skript.getInstance().getDataFolder().getAbsolutePath(), "materials.json");
        if (Files.exists(materialsFile, new LinkOption[0])) {
            content = null;
            try {
                content = new String(Files.readAllBytes(materialsFile), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, "Loading material registry failed!");
            }
            if (content != null) {
                String[] names = (String[])gson.fromJson(content, String[].class);
                assert (names != null);
                materialRegistry = MaterialRegistry.load(names);
            } else {
                materialRegistry = new MaterialRegistry();
            }
        } else {
            materialRegistry = new MaterialRegistry();
        }
        content = gson.toJson((Object)materialRegistry.getMaterials());
        try {
            Files.write(materialsFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, "Saving material registry failed!");
        }
        m_named = new Message("aliases.named");
        itemDataValues = !Skript.isRunningMinecraft(1, 13);
    }

    public ItemData(Material type, @Nullable String tags) {
        this.type = type;
        this.stack = new ItemStack(type);
        this.blockValues = BlockCompat.INSTANCE.getBlockValues(this.stack);
        if (tags != null) {
            this.applyTags(tags);
        }
    }

    public ItemData(Material type, int amount) {
        this.type = type;
        this.stack = new ItemStack(type, Math.abs(amount));
        this.blockValues = BlockCompat.INSTANCE.getBlockValues(this.stack);
    }

    public ItemData(Material type) {
        this(type, 1);
    }

    public ItemData(ItemData data) {
        this.stack = data.stack.clone();
        this.type = data.type;
        this.blockValues = data.blockValues;
        this.isAlias = data.isAlias;
        this.itemFlags = data.itemFlags;
    }

    public ItemData(ItemStack stack, @Nullable BlockValues values) {
        this.stack = stack;
        this.type = stack.getType();
        this.blockValues = values;
        if (this.type.getMaxDurability() != 0) {
            this.itemFlags |= 1;
        }
        if (stack.hasItemMeta()) {
            this.itemFlags |= 2;
        }
    }

    public ItemData(ItemStack stack) {
        this(stack, BlockCompat.INSTANCE.getBlockValues(stack));
        this.itemForm = true;
    }

    public ItemData(BlockState block) {
        this.type = ItemUtils.asItem(block.getType());
        this.stack = new ItemStack(this.type);
        this.blockValues = BlockCompat.INSTANCE.getBlockValues(block);
    }

    public ItemData(Block block) {
        this(block.getState());
    }

    public ItemData() {
    }

    public boolean isOfType(@Nullable ItemStack item) {
        if (item == null) {
            return this.type == Material.AIR;
        }
        if (this.type != item.getType()) {
            return false;
        }
        if (this.itemFlags != 0) {
            if (ItemUtils.getDamage(this.stack) != ItemUtils.getDamage(item)) {
                return false;
            }
            if (this.stack.hasItemMeta() == item.hasItemMeta()) {
                return this.stack.hasItemMeta() ? itemFactory.equals(this.stack.getItemMeta(), item.getItemMeta()) : true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean debug, boolean plural) {
        StringBuilder builder = new StringBuilder(Aliases.getMaterialName(this, plural));
        ItemMeta meta = this.stack.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            builder.append(" ").append(m_named).append(" ");
            builder.append(meta.getDisplayName());
        }
        return builder.toString();
    }

    public int getGender() {
        return Aliases.getGender(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemData)) {
            return false;
        }
        ItemData other = (ItemData)obj;
        if (this.isAlias) {
            return other.matchAlias(this).isAtLeast(MatchQuality.SAME_ITEM);
        }
        return this.matchAlias(other).isAtLeast(MatchQuality.SAME_ITEM);
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        if (this.blockValues == null || this.blockValues != null && this.blockValues.isDefault()) {
            hash = hash * 37 + 1;
        }
        return hash;
    }

    public MatchQuality matchAlias(ItemData item) {
        if (this.isAnything || item.isAnything) {
            return MatchQuality.EXACT;
        }
        if (item.getType() != this.getType()) {
            return MatchQuality.DIFFERENT;
        }
        BlockValues values = this.blockValues;
        if (!itemDataValues && this.itemForm && item.blockValues != null && !item.blockValues.isDefault()) {
            return MatchQuality.SAME_MATERIAL;
        }
        MatchQuality quality = MatchQuality.EXACT;
        if (values != null) {
            quality = item.blockValues != null ? values.match(item.blockValues) : MatchQuality.SAME_MATERIAL;
        }
        if (this.itemForm && ItemUtils.getDamage(this.stack) != ItemUtils.getDamage(item.stack)) {
            quality = item.hasFlag(1) ? MatchQuality.SAME_MATERIAL : MatchQuality.SAME_ITEM;
        }
        if (quality.isAtLeast(MatchQuality.SAME_ITEM)) {
            MatchQuality metaQuality = ItemData.compareItemMetas(this.getItemMeta(), item.getItemMeta());
            if (metaQuality == MatchQuality.SAME_MATERIAL && !item.hasFlag(2)) {
                quality = MatchQuality.SAME_ITEM;
            } else if (quality.isBetter(metaQuality)) {
                quality = metaQuality;
            }
        }
        return quality;
    }

    private boolean hasFlag(int flag) {
        return (this.itemFlags & flag) != 0;
    }

    private static MatchQuality compareItemMetas(ItemMeta first, ItemMeta second) {
        Set theirFlags;
        Set ourFlags;
        Map theirEnchants;
        Map ourEnchants;
        List theirLore;
        String theirName;
        MatchQuality quality = MatchQuality.EXACT;
        String ourName = first.hasDisplayName() ? first.getDisplayName() : null;
        String string = theirName = second.hasDisplayName() ? second.getDisplayName() : null;
        if (!Objects.equals(ourName, theirName)) {
            quality = theirName != null ? MatchQuality.SAME_MATERIAL : quality;
        }
        List ourLore = first.hasLore() ? first.getLore() : null;
        List list = theirLore = second.hasLore() ? second.getLore() : null;
        if (!Objects.equals(ourLore, theirLore)) {
            MatchQuality matchQuality = quality = theirLore != null ? MatchQuality.SAME_MATERIAL : quality;
        }
        if (!Objects.equals(ourEnchants = first.getEnchants(), theirEnchants = second.getEnchants())) {
            MatchQuality matchQuality = quality = !theirEnchants.isEmpty() ? MatchQuality.SAME_MATERIAL : quality;
        }
        if (!Objects.equals(ourFlags = first.getItemFlags(), theirFlags = second.getItemFlags())) {
            MatchQuality matchQuality = quality = !theirFlags.isEmpty() ? MatchQuality.SAME_MATERIAL : quality;
        }
        if (second instanceof PotionMeta) {
            PotionData theirPotion;
            if (!(first instanceof PotionMeta)) {
                return MatchQuality.DIFFERENT;
            }
            PotionData ourPotion = ((PotionMeta)first).getBasePotionData();
            return !Objects.equals(ourPotion, theirPotion = ((PotionMeta)second).getBasePotionData()) ? MatchQuality.SAME_MATERIAL : quality;
        }
        return quality;
    }

    public boolean isDefault() {
        return this.itemFlags == 0 && this.blockValues == null;
    }

    @Nullable
    public ItemData intersection(ItemData other) {
        if (other.type != this.type) {
            return null;
        }
        return this;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemData clone() {
        return new ItemData(this);
    }

    public Material getType() {
        return this.type;
    }

    @Nullable
    public BlockValues getBlockValues() {
        return this.blockValues;
    }

    public ItemMeta getItemMeta() {
        ItemMeta meta = this.stack.getItemMeta();
        if (meta == null) {
            meta = itemFactory.getItemMeta(Material.STONE);
        }
        assert (meta != null);
        return meta;
    }

    public void setItemMeta(ItemMeta meta) {
        this.stack.setItemMeta(meta);
        this.isAlias = false;
        this.itemFlags |= 2;
    }

    public int getDurability() {
        return ItemUtils.getDamage(this.stack);
    }

    public void setDurability(int durability) {
        ItemUtils.setDamage(this.stack, durability);
        this.isAlias = false;
        this.itemFlags |= 1;
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        Fields fields = new Fields(this);
        fields.putPrimitive("id", materialRegistry.getId(this.type));
        fields.putObject("meta", this.stack.getItemMeta());
        return fields;
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        this.type = materialRegistry.getMaterial(fields.getAndRemovePrimitive("id", Integer.TYPE));
        ItemMeta meta = fields.getAndRemoveObject("meta", ItemMeta.class);
        fields.setFields(this);
        this.stack = new ItemStack(this.type);
        this.stack.setItemMeta(meta);
    }

    public ItemData aliasCopy() {
        ItemData data = new ItemData();
        data.stack = new ItemStack(this.type, 1);
        if (this.stack.hasItemMeta()) {
            ItemMeta meta = this.stack.getItemMeta();
            meta.setDisplayName(null);
            data.stack.setItemMeta(meta);
        }
        if (!itemDataValues) {
            ItemUtils.setDamage(data.stack, 0);
        }
        data.type = this.type;
        data.blockValues = this.blockValues;
        data.itemForm = this.itemForm;
        return data;
    }

    public void applyMeta(ItemMeta meta) {
        ItemMeta our = this.getItemMeta();
        if (meta.hasLore()) {
            our.setLore(meta.getLore());
        }
        if (meta.hasDisplayName()) {
            our.setDisplayName(meta.getDisplayName());
        }
        if (meta.hasEnchants()) {
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                our.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
        }
        for (ItemFlag itemFlag : meta.getItemFlags()) {
            our.addItemFlags(new ItemFlag[]{itemFlag});
        }
        this.setItemMeta(meta);
    }

    public void applyTags(String tags) {
        BukkitUnsafe.modifyItemStack(this.stack, tags);
        this.itemFlags |= 2;
    }

    public static class OldItemData {
        int typeid = -1;
        public short dataMin = (short)-1;
        public short dataMax = (short)-1;
    }
}

