/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import org.bukkit.util.Vector;

public class VectorMath {
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;

    public static Vector fromSphericalCoordinates(double radius, double theta, double phi) {
        double r = Math.abs(radius);
        double t = theta * (Math.PI / 180);
        double p = phi * (Math.PI / 180);
        double sinp = Math.sin(p);
        double x = r * sinp * Math.cos(t);
        double y = r * Math.cos(p);
        double z = r * sinp * Math.sin(t);
        return new Vector(x, y, z);
    }

    public static Vector fromCylindricalCoordinates(double radius, double phi, double height) {
        double r = Math.abs(radius);
        double p = phi * (Math.PI / 180);
        double x = r * Math.cos(p);
        double z = r * Math.sin(p);
        return new Vector(x, height, z);
    }

    public static Vector fromYawAndPitch(float yaw, float pitch) {
        double y = Math.sin((double)pitch * (Math.PI / 180));
        double div = Math.cos((double)pitch * (Math.PI / 180));
        double x = Math.cos((double)yaw * (Math.PI / 180));
        double z = Math.sin((double)yaw * (Math.PI / 180));
        return new Vector(x *= div, y, z *= div);
    }

    public static float getYaw(Vector vector) {
        if (Double.valueOf(vector.getX()).equals(0.0) && Double.valueOf(vector.getZ()).equals(0.0)) {
            return 0.0f;
        }
        return (float)(Math.atan2(vector.getZ(), vector.getX()) * 57.29577951308232);
    }

    public static float getPitch(Vector vector) {
        double xy = Math.sqrt(vector.getX() * vector.getX() + vector.getZ() * vector.getZ());
        return (float)(Math.atan(vector.getY() / xy) * 57.29577951308232);
    }

    public static Vector setYaw(Vector vector, float yaw) {
        vector = VectorMath.fromYawAndPitch(yaw, VectorMath.getPitch(vector));
        return vector;
    }

    public static Vector setPitch(Vector vector, float pitch) {
        vector = VectorMath.fromYawAndPitch(VectorMath.getYaw(vector), pitch);
        return vector;
    }

    public static Vector rotX(Vector vector, double angle) {
        double sin = Math.sin(angle * (Math.PI / 180));
        double cos = Math.cos(angle * (Math.PI / 180));
        Vector vy = new Vector(0.0, cos, -sin);
        Vector vz = new Vector(0.0, sin, cos);
        Vector clone = vector.clone();
        vector.setY(clone.dot(vy));
        vector.setZ(clone.dot(vz));
        return vector;
    }

    public static Vector rotY(Vector vector, double angle) {
        double sin = Math.sin(angle * (Math.PI / 180));
        double cos = Math.cos(angle * (Math.PI / 180));
        Vector vx = new Vector(cos, 0.0, sin);
        Vector vz = new Vector(-sin, 0.0, cos);
        Vector clone = vector.clone();
        vector.setX(clone.dot(vx));
        vector.setZ(clone.dot(vz));
        return vector;
    }

    public static Vector rotZ(Vector vector, double angle) {
        double sin = Math.sin(angle * (Math.PI / 180));
        double cos = Math.cos(angle * (Math.PI / 180));
        Vector vx = new Vector(cos, -sin, 0.0);
        Vector vy = new Vector(sin, cos, 0.0);
        Vector clone = vector.clone();
        vector.setX(clone.dot(vx));
        vector.setY(clone.dot(vy));
        return vector;
    }

    public static Vector rot(Vector vector, Vector axis, double angle) {
        double sin = Math.sin(angle * (Math.PI / 180));
        double cos = Math.cos(angle * (Math.PI / 180));
        Vector a = axis.clone().normalize();
        double ax = a.getX();
        double ay = a.getY();
        double az = a.getZ();
        Vector rotx = new Vector(cos + ax * ax * (1.0 - cos), ax * ay * (1.0 - cos) - az * sin, ax * az * (1.0 - cos) + ay * sin);
        Vector roty = new Vector(ay * ax * (1.0 - cos) + az * sin, cos + ay * ay * (1.0 - cos), ay * az * (1.0 - cos) - ax * sin);
        Vector rotz = new Vector(az * ax * (1.0 - cos) - ay * sin, az * ay * (1.0 - cos) + ax * sin, cos + az * az * (1.0 - cos));
        double x = rotx.dot(vector);
        double y = roty.dot(vector);
        double z = rotz.dot(vector);
        vector.setX(x).setY(y).setZ(z);
        return vector;
    }

    public static float notchYaw(float yaw) {
        float y = yaw - 90.0f;
        if (y < -180.0f) {
            y += 360.0f;
        }
        return y;
    }

    public static float notchPitch(float pitch) {
        return -pitch;
    }

    public static float fromNotchYaw(float notchYaw) {
        float y = notchYaw + 90.0f;
        if (y > 180.0f) {
            y -= 360.0f;
        }
        return y;
    }

    public static float fromNotchPitch(float notchPitch) {
        return -notchPitch;
    }

    public static float skriptYaw(float yaw) {
        float y = yaw - 90.0f;
        if (y < 0.0f) {
            y += 360.0f;
        }
        return y;
    }

    public static float skriptPitch(float pitch) {
        return -pitch;
    }

    public static float fromSkriptYaw(float yaw) {
        float y = yaw + 90.0f;
        if (y > 360.0f) {
            y -= 360.0f;
        }
        return y;
    }

    public static float fromSkriptPitch(float pitch) {
        return -pitch;
    }

    public static float wrapAngleDeg(float angle) {
        if ((angle %= 360.0f) <= -180.0f) {
            return angle + 360.0f;
        }
        if (angle > 180.0f) {
            return angle - 360.0f;
        }
        return angle;
    }
}

