/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value=false)
public abstract class Math2 {
    public static int min(int a, int b, int c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    public static int min(int ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return 0;
        }
        int min = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] < min) {
                min = nums[i];
            }
            ++i;
        }
        return min;
    }

    public static int max(int a, int b, int c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    public static int max(int ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return 0;
        }
        int max = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] > max) {
                max = nums[i];
            }
            ++i;
        }
        return max;
    }

    public static double min(double a, double b, double c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    public static double min(double ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return Double.NaN;
        }
        double min = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] < min) {
                min = nums[i];
            }
            ++i;
        }
        return min;
    }

    public static double max(double a, double b, double c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    public static double max(double ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return Double.NaN;
        }
        double max = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] > max) {
                max = nums[i];
            }
            ++i;
        }
        return max;
    }

    public static int minPositive(int ... nums) {
        int max = -1;
        if (nums != null) {
            int[] nArray = nums;
            int n = nums.length;
            int n2 = 0;
            while (n2 < n) {
                int num = nArray[n2];
                if (num >= 0 && (num < max || max == -1)) {
                    max = num;
                }
                ++n2;
            }
        }
        return max;
    }

    public static int fit(int min, int x, int max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static short fit(short min, short x, short max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static long fit(long min, long x, long max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static float fit(float min, float x, float max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static double fit(double min, double x, double max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static double mod(double d, double m) {
        double r = d % m;
        return r < 0.0 ? r + m : r;
    }

    public static float mod(float d, float m) {
        float r = d % m;
        return r < 0.0f ? r + m : r;
    }

    public static int mod(int d, int m) {
        int r = d % m;
        return r < 0 ? r + m : r % m;
    }

    public static long mod(long d, long m) {
        long r = d % m;
        return r < 0L ? r + m : r % m;
    }

    public static long floor(double d) {
        long l = (long)d;
        if (!(d < 0.0)) {
            return l;
        }
        if (l == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return d == (double)l ? l : l - 1L;
    }

    public static long ceil(double d) {
        long l = (long)d;
        if (!(d > 0.0)) {
            return l;
        }
        if (l == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return d == (double)l ? l : l + 1L;
    }

    public static long round(double d) {
        if (d == 0.49999999999999994) {
            return 0L;
        }
        if (Math.getExponent(d) >= 52) {
            return (long)d;
        }
        return Math2.floor(d + 0.5);
    }

    public static int floorI(double d) {
        int i = (int)d;
        if (!(d < 0.0)) {
            return i;
        }
        if (i == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return d == (double)i ? i : i - 1;
    }

    public static int ceilI(double d) {
        int i = (int)d;
        if (!(d > 0.0)) {
            return i;
        }
        if (i == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return d == (double)i ? i : i + 1;
    }

    public static int roundI(double d) {
        if (d == 0.49999999999999994) {
            return 0;
        }
        if (Math.getExponent(d) >= 52) {
            return (int)d;
        }
        return Math2.floorI(d + 0.5);
    }

    public static long floor(float f) {
        long l = (long)f;
        if (!(f < 0.0f)) {
            return l;
        }
        if (l == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return f == (float)l ? l : l - 1L;
    }

    public static long ceil(float f) {
        long l = (long)f;
        if (!(f > 0.0f)) {
            return l;
        }
        if (l == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return f == (float)l ? l : l + 1L;
    }

    public static long round(float f) {
        if (f == 0.49999997f) {
            return 0L;
        }
        if (Math.getExponent(f) >= 23) {
            return (long)f;
        }
        return Math2.floor(f + 0.5f);
    }

    public static int floorI(float f) {
        int i = (int)f;
        if (!(f < 0.0f)) {
            return i;
        }
        if (i == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return f == (float)i ? i : i - 1;
    }

    public static int ceilI(float f) {
        int i = (int)f;
        if (!(f > 0.0f)) {
            return i;
        }
        if (i == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return f == (float)i ? i : i + 1;
    }

    public static int roundI(float f) {
        if (f == 0.49999997f) {
            return 0;
        }
        if (Math.getExponent(f) >= 23) {
            return (int)f;
        }
        return Math2.floorI(f + 0.5f);
    }

    public static int nextPowerOfTwo(int n) {
        if (n < 0) {
            int h = ~n;
            h |= h >> 1;
            h |= h >> 2;
            h |= h >> 4;
            h |= h >> 8;
            h |= h >> 16;
            return n == (h ^= 0xFFFFFFFF) ? n : h >> 1;
        }
        int h = Integer.highestOneBit(n);
        return n == h ? n : h << 1;
    }

    public static long nextPowerOfTwo(long n) {
        if (n < 0L) {
            long h = n ^ 0xFFFFFFFFFFFFFFFFL;
            h |= h >> 1;
            h |= h >> 2;
            h |= h >> 4;
            h |= h >> 8;
            h |= h >> 16;
            h |= h >> 32;
            return n == (h ^= 0xFFFFFFFFFFFFFFFFL) ? n : h >> 1;
        }
        long h = Long.highestOneBit(n);
        return n == h ? n : h << 1;
    }

    public static double frac(double d) {
        double r = Math2.mod(d, 1.0);
        return r == 1.0 ? 0.0 : r;
    }

    public static float frac(float f) {
        float r = Math2.mod(f, 1.0f);
        return r == 1.0f ? 0.0f : r;
    }

    public static int sign(byte i) {
        return i >> 7 | -i >>> 7;
    }

    public static int sign(short i) {
        return i >> 15 | -i >>> 15;
    }

    public static int sign(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static int sign(long i) {
        return (int)(i >> 63) | (int)(-i >>> 63);
    }

    public static int sign(float f) {
        return f > 0.0f ? 1 : (f < 0.0f ? -1 : 0);
    }

    public static int sign(double d) {
        return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
    }

    public static double smoothStep(double x, double x1, double x2) {
        double d = Math2.fit(0.0, (x - x1) / (x2 - x1), 1.0);
        return d * d * (3.0 - 2.0 * d);
    }
}

