/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Sorted List")
@Description(value={"Sorts given list in natural order. All objects in list must be comparable;", "if they're not, this expression will return nothing."})
@Examples(value={"set {_sorted::*} to sorted {_players::*}"})
@Since(value="2.2-dev19")
public class ExprSortedList
extends SimpleExpression<Object> {
    private Expression<Object> list;

    static {
        Skript.registerExpression(ExprSortedList.class, Object.class, ExpressionType.COMBINED, "sorted %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = exprs[0];
        return true;
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        Object[] unsorted = this.list.getAll(e);
        Object[] sorted = new Object[unsorted.length];
        int i = 0;
        while (i < sorted.length) {
            Object value = unsorted[i];
            sorted[i] = value instanceof Long ? Double.valueOf(((Long)value).longValue()) : value;
            ++i;
        }
        try {
            Arrays.sort(sorted);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return sorted;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "sorted list";
    }
}

