/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.stream.Stream;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Enchantment Level")
@Description(value={"The level of a particular <a href='classes.html#enchantment'>enchantment</a> on an item."})
@Examples(value={"player's tool is a sword of sharpness:", "\tmessage \"You have a sword of sharpness %level of sharpness of the player's tool% equipped\""})
@Since(value="2.0")
public class ExprEnchantmentLevel
extends SimpleExpression<Integer> {
    private Expression<ItemType> items;
    private Expression<Enchantment> enchants;

    static {
        Skript.registerExpression(ExprEnchantmentLevel.class, Integer.class, ExpressionType.PROPERTY, "[the] [enchant[ment]] level[s] of %enchantments% (on|of) %itemtypes%", "[the] %enchantments% [enchant[ment]] level[s] (on|of) %itemtypes%", "%itemtypes%'[s] %enchantments% [enchant[ment]] level[s]", "%itemtypes%'[s] [enchant[ment]] level[s] of %enchantments%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int i = matchedPattern < 2 ? 1 : 0;
        this.items = exprs[i];
        this.enchants = exprs[i ^ 1];
        return true;
    }

    protected Integer[] get(Event e) {
        Enchantment[] enchantments = this.enchants.getArray(e);
        return (Integer[])Stream.of(this.items.getArray(e)).map(ItemType::getEnchantmentTypes).flatMap(enchantmentTypeArray -> Stream.of(enchantmentTypeArray)).filter(enchantment -> CollectionUtils.contains(enchantments, enchantment.getType())).map(EnchantmentType::getLevel).toArray(Integer[]::new);
    }

    @Override
    public boolean isSingle() {
        return this.items.isSingle() && this.enchants.isSingle();
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        ItemType[] source = this.items.getArray(e);
        Enchantment[] enchantments = this.enchants.getArray(e);
        int newLevel = ((Number)delta[0]).intValue();
        ItemType[] itemTypeArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType item = itemTypeArray[n2];
            if (item.hasAnyEnchantments(enchantments)) {
                EnchantmentType[] enchants = item.getEnchantmentTypes();
                assert (enchants != null);
                EnchantmentType[] enchantmentTypeArray = enchants;
                int n3 = enchants.length;
                int n4 = 0;
                while (n4 < n3) {
                    EnchantmentType enchant = enchantmentTypeArray[n4];
                    item.removeEnchantments(enchant);
                    Enchantment type = enchant.getType();
                    int changed = newLevel;
                    assert (type != null);
                    if (mode == Changer.ChangeMode.ADD) {
                        changed = Math.max(0, enchant.getLevel() + changed);
                    } else if (mode == Changer.ChangeMode.REMOVE) {
                        changed = Math.max(0, enchant.getLevel() - changed);
                    }
                    if (changed > 0) {
                        item.addEnchantments(new EnchantmentType(type, newLevel));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the level of " + this.enchants.toString(e, debug) + " of " + this.items.toString(e, debug);
    }
}

