/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Drops")
@Description(value={"Only works in block break and death events. Holds the drops of the dying creature. Drops can be prevented by removing them with \"remove ... from drops\", e.g. \"remove all pickaxes from the drops\", or \"clear drops\" if you don't want any drops at all. In break events, drops can only be cleared, and is only available in 1.12+"})
@Examples(value={"clear drops", "remove 4 planks from the drops", "on break of diamond ore:", "\tclear drops"})
@Since(value="1.0, 2.4 (block break event drops)")
@Events(value={"break / mine, death"})
public class ExprDrops
extends SimpleExpression<ItemStack> {
    private final boolean BREAK_DROPS = Skript.methodExists(BlockBreakEvent.class, "setDropItems", Boolean.TYPE);
    private Kleenean delayed;

    static {
        Skript.registerExpression(ExprDrops.class, ItemStack.class, ExpressionType.SIMPLE, "[the] drops");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (this.BREAK_DROPS) {
            if (!ScriptLoader.isCurrentEvent(EntityDeathEvent.class, BlockBreakEvent.class)) {
                Skript.error("The expression 'drops' can only be used in block break and death events", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
        } else if (!ScriptLoader.isCurrentEvent(EntityDeathEvent.class)) {
            Skript.error("The expression 'drops' can only be used in death events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delayed = isDelayed;
        return true;
    }

    @Nullable
    protected ItemStack[] get(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return new ItemStack[0];
        }
        return ((EntityDeathEvent)e).getDrops().toArray(new ItemStack[0]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return null;
        }
        if (this.delayed.isTrue()) {
            Skript.error("Can't change the drops anymore after the event has already passed");
            return null;
        }
        return CollectionUtils.array(ItemType[].class, Inventory[].class, Experience[].class);
    }

    @Override
    public void change(Event e, @Nullable Object[] deltas, Changer.ChangeMode mode) {
        assert (mode != Changer.ChangeMode.RESET);
        if (e instanceof BlockBreakEvent && mode == Changer.ChangeMode.DELETE) {
            ((BlockBreakEvent)e).setDropItems(false);
            return;
        }
        if (!(e instanceof EntityDeathEvent)) {
            assert (false);
            return;
        }
        List drops = ((EntityDeathEvent)e).getDrops();
        if (mode == Changer.ChangeMode.DELETE) {
            drops.clear();
            return;
        }
        boolean cleared = false;
        assert (deltas != null);
        Object[] objectArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            Object delta = objectArray[n2];
            if (delta instanceof Experience) {
                if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.REMOVE && ((Experience)delta).getInternalXP() == -1) {
                    ((EntityDeathEvent)e).setDroppedExp(0);
                } else if (mode == Changer.ChangeMode.SET) {
                    ((EntityDeathEvent)e).setDroppedExp(((Experience)delta).getXP());
                } else {
                    ((EntityDeathEvent)e).setDroppedExp(Math.max(0, ((EntityDeathEvent)e).getDroppedExp() + (mode == Changer.ChangeMode.ADD ? 1 : -1) * ((Experience)delta).getXP()));
                }
            } else {
                switch (mode) {
                    case SET: {
                        if (!cleared) {
                            drops.clear();
                            cleared = true;
                        }
                    }
                    case ADD: {
                        if (delta instanceof Inventory) {
                            for (ItemStack is : new IteratorIterable(((Inventory)delta).iterator())) {
                                if (is == null) continue;
                                drops.add(is);
                            }
                            break;
                        }
                        ((ItemType)delta).addTo(drops);
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        if (delta instanceof Inventory) {
                            for (ItemStack is : new IteratorIterable(((Inventory)delta).iterator())) {
                                if (is == null) continue;
                                if (mode == Changer.ChangeMode.REMOVE) {
                                    new ItemType(is).removeFrom(drops);
                                    continue;
                                }
                                new ItemType(is).removeAll(drops);
                            }
                            break;
                        }
                        if (mode == Changer.ChangeMode.REMOVE) {
                            ((ItemType)delta).removeFrom(drops);
                            break;
                        }
                        ((ItemType)delta).removeAll(drops);
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        assert (false);
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the drops";
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean isSingle() {
        return false;
    }
}

