/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Default Value")
@Description(value={"A shorthand expression for giving things a default value. If the first thing isn't set, the second thing will be returned."})
@Examples(value={"broadcast {score::%player's uuid%} otherwise \"%player% has no score!\""})
@Since(value="2.2-dev36")
public class ExprDefaultValue<T>
extends SimpleExpression<T> {
    private final ExprDefaultValue<?> source;
    private final Class<T> superType;
    @Nullable
    private Expression<Object> first;
    @Nullable
    private Expression<Object> second;

    static {
        Skript.registerExpression(ExprDefaultValue.class, Object.class, ExpressionType.COMBINED, "%objects% (otherwise|?) %objects%");
    }

    public ExprDefaultValue() {
        this(null, Object.class);
    }

    private ExprDefaultValue(ExprDefaultValue<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.first = source.first;
            this.second = source.second;
        }
        this.superType = Utils.getSuperType(types);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = LiteralUtils.defendExpression(exprs[0]);
        this.second = LiteralUtils.defendExpression(exprs[1]);
        return LiteralUtils.canInitSafely(this.first, this.second);
    }

    @Override
    protected T[] get(Event e) {
        Object[] first = this.first.getArray(e);
        Object[] values = first.length != 0 ? first : this.second.getArray(e);
        try {
            return Converters.convertStrictly(values, this.superType);
        }
        catch (ClassCastException e1) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprDefaultValue<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public boolean isSingle() {
        return this.first.isSingle() && this.second.isSingle();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.first.toString(e, debug)) + " or else " + this.second.toString(e, debug);
    }
}

