/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Colour of")
@Description(value={"The <a href='../classes.html#color'>colour</a> of an item, can also be used to colour chat messages with \"&lt;%colour of ...%&gt;this text is coloured!\"."})
@Examples(value={"on click on wool:", "\tmessage \"This wool block is <%colour of block%>%colour of block%<reset>!\"", "\tset the colour of the block to black"})
@Since(value="1.2")
public class ExprColorOf
extends PropertyExpression<Object, Color> {
    static {
        ExprColorOf.register(ExprColorOf.class, Color.class, "colo[u]r[s]", "blocks/itemtypes/entities/fireworkeffects");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Color[] get(Event e, Object[] source) {
        if (source instanceof FireworkEffect[]) {
            ArrayList colors = new ArrayList();
            FireworkEffect[] fireworkEffectArray = (FireworkEffect[])source;
            int n = fireworkEffectArray.length;
            int n2 = 0;
            while (n2 < n) {
                FireworkEffect effect = fireworkEffectArray[n2];
                effect.getColors().stream().map(SkriptColor::fromBukkitColor).filter(Optional::isPresent).map(Optional::get).forEach(colors::add);
                ++n2;
            }
            if (colors.size() == 0) {
                return null;
            }
            return colors.toArray(new Color[0]);
        }
        return this.get(source, o -> {
            Colorable colorable = this.getColorable(o);
            if (colorable == null) {
                return null;
            }
            Optional<SkriptColor> color = SkriptColor.fromDyeColor(colorable.getColor());
            return color.orElse(null);
        });
    }

    @Override
    public Class<? extends Color> getReturnType() {
        return Color.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "colour of " + this.getExpr().toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class returnType = this.getExpr().getReturnType();
        if (FireworkEffect.class.isAssignableFrom(returnType)) {
            return CollectionUtils.array(Color[].class);
        }
        if (mode != Changer.ChangeMode.SET && !this.getExpr().isSingle()) {
            return null;
        }
        if (Entity.class.isAssignableFrom(returnType)) {
            return CollectionUtils.array(Color.class);
        }
        if (Block.class.isAssignableFrom(returnType)) {
            return CollectionUtils.array(Color.class);
        }
        if (ItemType.class.isAssignableFrom(returnType)) {
            return CollectionUtils.array(Color.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        DyeColor color = ((Color)delta[0]).asDyeColor();
        F[] FArray = this.getExpr().getArray(e);
        int n = FArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = FArray[n2];
            if (o instanceof Item || o instanceof ItemType) {
                MaterialData data;
                ItemStack stack;
                ItemStack itemStack = stack = o instanceof Item ? ((Item)o).getItemStack() : ((ItemType)o).getRandom();
                if (stack != null && (data = stack.getData()) instanceof Colorable) {
                    ((Colorable)data).setColor(color);
                    stack.setData(data);
                    if (o instanceof Item) {
                        ((Item)o).setItemStack(stack);
                    }
                }
            } else if (o instanceof Block || o instanceof Colorable) {
                Colorable colorable = this.getColorable(o);
                if (colorable != null) {
                    colorable.setColor(color);
                }
            } else if (o instanceof FireworkEffect) {
                Color[] input = (Color[])delta;
                FireworkEffect effect = (FireworkEffect)o;
                switch (mode) {
                    case ADD: {
                        Color c;
                        Color[] colorArray = input;
                        int n3 = input.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            c = colorArray[n4];
                            effect.getColors().add(c.asBukkitColor());
                            ++n4;
                        }
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        Color c;
                        Color[] colorArray = input;
                        int n3 = input.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            c = colorArray[n4];
                            effect.getColors().remove(c.asBukkitColor());
                            ++n4;
                        }
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        effect.getColors().clear();
                        break;
                    }
                    case SET: {
                        Color c;
                        effect.getColors().clear();
                        Color[] colorArray = input;
                        int n3 = input.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            c = colorArray[n4];
                            effect.getColors().add(c.asBukkitColor());
                            ++n4;
                        }
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    @Nullable
    private Colorable getColorable(Object colorable) {
        if (colorable instanceof Item || colorable instanceof ItemType) {
            ItemStack item;
            ItemStack itemStack = item = colorable instanceof Item ? ((Item)colorable).getItemStack() : ((ItemType)colorable).getRandom();
            if (item == null) {
                return null;
            }
            MaterialData data = item.getData();
            if (data instanceof Colorable) {
                return (Colorable)data;
            }
        } else if (colorable instanceof Block) {
            BlockState state = ((Block)colorable).getState();
            if (state instanceof Colorable) {
                return (Colorable)state;
            }
        } else if (colorable instanceof Colorable) {
            return (Colorable)colorable;
        }
        return null;
    }
}

