/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player List Header and Footer")
@Description(value={"The message above and below the player list in the tab menu."})
@Examples(value={"set all players tab list header to \"Welcome to the Server!\"", "send \"%the player's tab list header%\" to player", "reset all player's tab list header"})
@Since(value="2.4")
@RequiredPlugins(value={"Spigot 1.13 or newer"})
public class ExprPlayerlistHeaderFooter
extends PropertyExpression<Player, String> {
    private static final int HEADER = 1;
    private static final int FOOTER = 2;
    private int mark;

    static {
        if (Skript.methodExists(Player.class, "setPlayerListHeaderFooter", String.class, String.class)) {
            Skript.registerExpression(ExprPlayerlistHeaderFooter.class, String.class, ExpressionType.PROPERTY, "[the] %players% (player|tab) list (1\u00a6header|2\u00a6footer)");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        this.setExpr(exprs[0]);
        return true;
    }

    protected String[] get(Event e, Player[] source) {
        ArrayList<String> list = new ArrayList<String>();
        Player[] playerArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (this.mark == 1) {
                list.add(player.getPlayerListHeader());
            } else if (this.mark == 2) {
                list.add(player.getPlayerListFooter());
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(String.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String text = delta == null ? "" : (String)delta[0];
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (this.mark == 1) {
                player.setPlayerListHeader(text);
            } else if (this.mark == 2) {
                player.setPlayerListFooter(text);
            }
            ++n2;
        }
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + this.getExpr().toString(e, debug) + " player list " + (this.mark == 1 ? "header" : (this.mark == 2 ? "footer" : ""));
    }
}

