/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Create Location from Vector")
@Description(value={"Creates a location from a vector in a world."})
@Examples(value={"set {_loc} to {_v} to location in world \"world\"", "set {_loc} to {_v} to location in world \"world\" with yaw 45 and pitch 90", "set {_loc} to location of {_v} in \"world\" with yaw 45 and pitch 90"})
@Since(value="2.2-dev28")
public class ExprLocationFromVector
extends SimpleExpression<Location> {
    private Expression<Vector> vector;
    private Expression<World> world;
    private Expression<Number> yaw;
    private Expression<Number> pitch;
    private boolean yawpitch;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (exprs.length > 3) {
            this.yawpitch = true;
        }
        this.vector = exprs[0];
        this.world = exprs[1];
        if (this.yawpitch) {
            this.yaw = exprs[2];
            this.pitch = exprs[3];
        }
        return true;
    }

    protected Location[] get(Event e) {
        Number p;
        Vector v = this.vector.getSingle(e);
        World w = this.world.getSingle(e);
        Number y = this.yaw != null ? (Number)this.yaw.getSingle(e) : (Number)null;
        Number number = p = this.pitch != null ? (Number)this.pitch.getSingle(e) : (Number)null;
        if (v == null || w == null) {
            return null;
        }
        if (y == null || p == null) {
            return CollectionUtils.array(v.toLocation(w));
        }
        return CollectionUtils.array(v.toLocation(w, y.floatValue(), p.floatValue()));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.yawpitch) {
            return "location from " + this.vector.toString(e, debug) + " with yaw " + this.yaw.toString() + " and pitch " + this.pitch.toString(e, debug);
        }
        return "location from " + this.vector.toString(e, debug);
    }
}

