/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.eclipse.jdt.annotation.Nullable;

public class ZombieVillagerData
extends EntityData<ZombieVillager> {
    private static final boolean villagerSupport = Skript.isRunningMinecraft(1, 11);
    private static final boolean PROFESSION_UPDATE = Skript.isRunningMinecraft(1, 14);
    private static final Villager.Profession[] professions = Villager.Profession.values();
    private Villager.Profession profession = PROFESSION_UPDATE ? Villager.Profession.NONE : Villager.Profession.valueOf((String)"NORMAL");

    static {
        if (villagerSupport) {
            EntityData.register(ZombieVillagerData.class, "zombie villager", ZombieVillager.class, 0, "zombie villager", "zombie farmer", "zombie librarian", "zombie priest", "zombie blacksmith", "zombie butcher", "zombie nitwit");
        }
    }

    public ZombieVillagerData() {
    }

    public ZombieVillagerData(Villager.Profession prof) {
        this.profession = prof;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.profession = professions[matchedPattern];
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends ZombieVillager> c, @Nullable ZombieVillager e) {
        if (e == null) {
            return true;
        }
        this.profession = e.getVillagerProfession();
        return true;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.profession = professions[Integer.parseInt(s)];
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new SkriptAPIException("Cannot parse zombie villager type " + s);
        }
        return true;
    }

    @Override
    public void set(ZombieVillager e) {
        this.profession = e.getVillagerProfession();
    }

    @Override
    protected boolean match(ZombieVillager e) {
        return e.getVillagerProfession() == this.profession;
    }

    @Override
    public Class<? extends ZombieVillager> getType() {
        return ZombieVillager.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof ZombieVillagerData)) {
            return false;
        }
        return ((ZombieVillagerData)obj).profession == this.profession;
    }

    @Override
    protected int hashCode_i() {
        return this.profession.hashCode();
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof ZombieVillagerData) {
            return ((ZombieVillagerData)e).profession.equals((Object)this.profession);
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new ZombieVillagerData(this.profession);
    }
}

