/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Llama;
import org.bukkit.entity.TraderLlama;
import org.eclipse.jdt.annotation.Nullable;

public class LlamaData
extends EntityData<Llama> {
    private static final boolean TRADER_SUPPORT = Skript.isRunningMinecraft(1, 14);
    @Nullable
    private Llama.Color color = null;
    private boolean isTrader;

    static {
        if (TRADER_SUPPORT) {
            EntityData.register(LlamaData.class, "llama", Llama.class, 0, "llama", "trader llama", "creamy llama", "white llama", "brown llama", "gray llama");
        } else if (Skript.isRunningMinecraft(1, 11)) {
            EntityData.register(LlamaData.class, "llama", Llama.class, 0, "llama", "creamy llama", "white llama", "brown llama", "gray llama");
        }
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        boolean bl = this.isTrader = TRADER_SUPPORT && matchedPattern == 1 || Utils.isEither(parseResult.mark, 2, 3, 6, 7);
        if (!TRADER_SUPPORT && this.isTrader) {
            return false;
        }
        if (matchedPattern > (TRADER_SUPPORT ? 1 : 0)) {
            this.color = Llama.Color.values()[matchedPattern - (TRADER_SUPPORT ? 2 : 1)];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Llama> c, @Nullable Llama llama) {
        if (TRADER_SUPPORT && c != null) {
            this.isTrader = c.isAssignableFrom(TraderLlama.class);
        }
        if (llama != null) {
            this.color = llama.getColor();
        }
        return true;
    }

    @Override
    public void set(Llama entity) {
        Llama.Color randomColor;
        Llama.Color color = randomColor = this.color == null ? CollectionUtils.getRandom(Llama.Color.values()) : this.color;
        assert (randomColor != null);
        entity.setColor(randomColor);
    }

    @Override
    protected boolean match(Llama entity) {
        return this.color == null || this.color == entity.getColor() || TRADER_SUPPORT && this.isTrader == entity instanceof TraderLlama;
    }

    @Override
    public Class<? extends Llama> getType() {
        return this.isTrader ? Llama.class : TraderLlama.class;
    }

    @Override
    public EntityData getSuperType() {
        return new LlamaData();
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.isTrader ? 1 : 0);
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof LlamaData)) {
            return false;
        }
        LlamaData d = (LlamaData)data;
        return this.isTrader == d.isTrader && d.color == this.color;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof LlamaData)) {
            return false;
        }
        LlamaData d = (LlamaData)data;
        return this.isTrader != d.isTrader && (this.color == null || d.color == this.color);
    }
}

