/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="PvP")
@Description(value={"Checks the PvP state of a world."})
@Examples(value={"PvP is enabled", "PvP is disabled in \"world\""})
@Since(value="1.3.4")
public class CondPvP
extends Condition {
    private Expression<World> worlds;
    private boolean enabled;

    static {
        Skript.registerCondition(CondPvP.class, "(is PvP|PvP is) enabled [in %worlds%]", "(is PvP|PvP is) disabled [in %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.worlds = exprs[0];
        this.enabled = matchedPattern == 0;
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.worlds.check(e, w -> w.getPVP() == this.enabled, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "PvP is " + (this.enabled ? "enabled" : "disabled") + " in " + this.worlds.toString(e, debug);
    }
}

