/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EnchantmentUtils;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.ConfigurationSerializer;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.ExprDamageCause;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.BiomeUtils;
import ch.njol.skript.util.DamageCauseUtils;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.EnumUtils;
import ch.njol.skript.util.InventoryActions;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.StringMode;
import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.Metadatable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.CachedServerIcon;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

public class BukkitClasses {
    static {
        Classes.registerClass(new ClassInfo<Entity>(Entity.class, "entity").user("entit(y|ies)").name("Entity").description("An entity is something in a <a href='#world'>world</a> that's not a <a href='#block'>block</a>, e.g. a <a href='#player'>player</a>, a skeleton, or a zombie, but also <a href='#projectile'>projectiles</a> like arrows, fireballs or thrown potions, or special entities like dropped items, falling blocks or paintings.").usage("player, op, wolf, tamed ocelot, powered creeper, zombie, unsaddled pig, fireball, arrow, dropped item, item frame, etc.").examples("entity is a zombie or creeper", "player is an op", "projectile is an arrow", "shoot a fireball from the player").since("1.0").defaultExpression(new EventValueExpression<Entity>(Entity.class)).parser(new Parser<Entity>(){

            @Override
            @Nullable
            public Entity parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toVariableNameString(Entity e) {
                return "entity:" + e.getUniqueId().toString().toLowerCase(Locale.ENGLISH);
            }

            @Override
            public String getVariableNamePattern() {
                return "entity:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
            }

            @Override
            public String toString(Entity e, int flags) {
                return EntityData.toString(e, flags);
            }
        }).changer(DefaultChangers.entityChanger));
        Classes.registerClass(new ClassInfo<LivingEntity>(LivingEntity.class, "livingentity").user("living ?entit(y|ies)").name("Living Entity").description("A living <a href='#entity'>entity</a>, i.e. a mob or <a href='#player'>player</a>, not inanimate entities like <a href='#projectile'>projectiles</a> or dropped items.").usage("see <a href='#entity'>entity</a>, but ignore inanimate objects").examples("spawn 5 powered creepers", "shoot a zombie from the creeper").since("1.0").defaultExpression(new EventValueExpression<LivingEntity>(LivingEntity.class)).changer(DefaultChangers.entityChanger));
        Classes.registerClass(new ClassInfo<Projectile>(Projectile.class, "projectile").user("projectiles?").name("Projectile").description("A projectile, e.g. an arrow, snowball or thrown potion.").usage("arrow, fireball, snowball, thrown potion, etc.").examples("projectile is a snowball", "shoot an arrow at speed 5 from the player").since("1.0").defaultExpression(new EventValueExpression<Projectile>(Projectile.class)).changer(DefaultChangers.nonLivingEntityChanger));
        Classes.registerClass(new ClassInfo<Block>(Block.class, "block").user("blocks?").name("Block").description("A block in a <a href='#world'>world</a>. It has a <a href='#location'>location</a> and a <a href='#itemstack'>type</a>, and can also have a <a href='#direction'>direction</a> (mostly a <a href='expressions.html#ExprFacing'>facing</a>), an <a href='#inventory'>inventory</a>, or other special properties.").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Block>(Block.class)).parser(new Parser<Block>(){

            @Override
            @Nullable
            public Block parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Block b, int flags) {
                return ItemType.toString(b, flags);
            }

            @Override
            public String toVariableNameString(Block b) {
                return String.valueOf(b.getWorld().getName()) + ":" + b.getX() + "," + b.getY() + "," + b.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+:-?\\d+,-?\\d+,-?\\d+";
            }

            @Override
            public String getDebugMessage(Block b) {
                return String.valueOf(this.toString(b, 0)) + " block (" + b.getWorld().getName() + ":" + b.getX() + "," + b.getY() + "," + b.getZ() + ")";
            }
        }).changer(DefaultChangers.blockChanger).serializer(new Serializer<Block>(){

            @Override
            public Fields serialize(Block b) {
                Fields f = new Fields();
                f.putObject("world", b.getWorld());
                f.putPrimitive("x", b.getX());
                f.putPrimitive("y", b.getY());
                f.putPrimitive("z", b.getZ());
                return f;
            }

            @Override
            public void deserialize(Block o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            protected Block deserialize(Fields fields) throws StreamCorruptedException {
                Block b;
                World w = fields.getObject("world", World.class);
                int x = fields.getPrimitive("x", Integer.TYPE);
                int y = fields.getPrimitive("y", Integer.TYPE);
                int z = fields.getPrimitive("z", Integer.TYPE);
                if (w == null || (b = w.getBlockAt(x, y, z)) == null) {
                    throw new StreamCorruptedException();
                }
                return b;
            }

            @Override
            public boolean mustSyncDeserialization() {
                return true;
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            @Nullable
            public Block deserialize(String s) {
                String[] split = s.split("[:,]");
                if (split.length != 4) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    int[] l = new int[3];
                    int i = 0;
                    while (i < 3) {
                        l[i] = Integer.parseInt(split[i + 1]);
                        ++i;
                    }
                    return w.getBlockAt(l[0], l[1], l[2]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Classes.registerClass(new ClassInfo<Location>(Location.class, "location").user("locations?").name("Location").description("A location in a <a href='#world'>world</a>. Locations are world-specific and even store a <a href='#direction'>direction</a>, e.g. if you save a location and later teleport to it you will face the exact same direction you did when you saved the location.").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Location>(Location.class)).parser(new Parser<Location>(){

            @Override
            @Nullable
            public Location parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Location l, int flags) {
                return "x: " + Skript.toString(l.getX()) + ", y: " + Skript.toString(l.getY()) + ", z: " + Skript.toString(l.getZ());
            }

            @Override
            public String toVariableNameString(Location l) {
                return String.valueOf(l.getWorld().getName()) + ":" + l.getX() + "," + l.getY() + "," + l.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S:-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?";
            }

            @Override
            public String getDebugMessage(Location l) {
                return "(" + l.getWorld().getName() + ":" + l.getX() + "," + l.getY() + "," + l.getZ() + "|yaw=" + l.getYaw() + "/pitch=" + l.getPitch() + ")";
            }
        }).serializer(new Serializer<Location>(){

            @Override
            public Fields serialize(Location l) {
                Fields f = new Fields();
                f.putObject("world", l.getWorld());
                f.putPrimitive("x", l.getX());
                f.putPrimitive("y", l.getY());
                f.putPrimitive("z", l.getZ());
                f.putPrimitive("yaw", Float.valueOf(l.getYaw()));
                f.putPrimitive("pitch", Float.valueOf(l.getPitch()));
                return f;
            }

            @Override
            public void deserialize(Location o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public Location deserialize(Fields f) throws StreamCorruptedException {
                return new Location(f.getObject("world", World.class), f.getPrimitive("x", Double.TYPE).doubleValue(), f.getPrimitive("y", Double.TYPE).doubleValue(), f.getPrimitive("z", Double.TYPE).doubleValue(), f.getPrimitive("yaw", Float.TYPE).floatValue(), f.getPrimitive("pitch", Float.TYPE).floatValue());
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            public boolean mustSyncDeserialization() {
                return true;
            }

            @Override
            @Nullable
            public Location deserialize(String s) {
                String[] split = s.split("[:,|/]");
                if (split.length != 6) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    double[] l = new double[5];
                    int i = 0;
                    while (i < 5) {
                        l[i] = Double.parseDouble(split[i + 1]);
                        ++i;
                    }
                    return new Location(w, l[0], l[1], l[2], (float)l[3], (float)l[4]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Classes.registerClass(new ClassInfo<Vector>(Vector.class, "vector").user("vectors?").name("Vector").description("Vector is a collection of numbers. In Minecraft, 3D vectors are used to express velocities of entities.").usage("vector(x, y, z)").examples("").since("2.2-dev23").defaultExpression(new EventValueExpression<Vector>(Vector.class)).parser(new Parser<Vector>(){

            @Override
            @Nullable
            public Vector parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Vector vec, int flags) {
                return "x: " + Skript.toString(vec.getX()) + ", y: " + Skript.toString(vec.getY()) + ", z: " + Skript.toString(vec.getZ());
            }

            @Override
            public String toVariableNameString(Vector vec) {
                return "vector:" + vec.getX() + "," + vec.getY() + "," + vec.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S:-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?";
            }

            @Override
            public String getDebugMessage(Vector vec) {
                return "(" + vec.getX() + "," + vec.getY() + "," + vec.getZ() + ")";
            }
        }).serializer(new Serializer<Vector>(){

            @Override
            public Fields serialize(Vector o) {
                Fields f = new Fields();
                f.putPrimitive("x", o.getX());
                f.putPrimitive("y", o.getY());
                f.putPrimitive("z", o.getZ());
                return f;
            }

            @Override
            public void deserialize(Vector o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public Vector deserialize(Fields f) throws StreamCorruptedException {
                return new Vector(f.getPrimitive("x", Double.TYPE).doubleValue(), f.getPrimitive("y", Double.TYPE).doubleValue(), f.getPrimitive("z", Double.TYPE).doubleValue());
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }

            @Override
            protected boolean canBeInstantiated() {
                return false;
            }
        }));
        Classes.registerClass(new ClassInfo<World>(World.class, "world").user("worlds?").name("World").description("One of the server's worlds. Worlds can be put into scripts by surrounding their name with double quotes, e.g. \"world_nether\", but this might not work reliably as <a href='#string'>text</a> uses the same syntax.").usage("<code>\"world_name\"</code>, e.g. \"world\"").examples("broadcast \"Hello!\" to the world \"world_nether\"").since("1.0, 2.2 (alternate syntax)").after("string").defaultExpression(new EventValueExpression<World>(World.class)).parser(new Parser<World>(){
            private final Pattern parsePattern = Pattern.compile("(?:(?:the )?world )?\"(.+)\"", 2);

            @Override
            @Nullable
            public World parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND || context == ParseContext.CONFIG) {
                    return Bukkit.getWorld((String)s);
                }
                Matcher m = this.parsePattern.matcher(s);
                if (m.matches()) {
                    return Bukkit.getWorld((String)m.group(1));
                }
                return null;
            }

            @Override
            public String toString(World w, int flags) {
                return w.getName();
            }

            @Override
            public String toVariableNameString(World w) {
                return w.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new Serializer<World>(){

            @Override
            public Fields serialize(World w) {
                Fields f = new Fields();
                f.putObject("name", w.getName());
                return f;
            }

            @Override
            public void deserialize(World o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            protected World deserialize(Fields fields) throws StreamCorruptedException {
                String name = fields.getObject("name", String.class);
                if (!$assertionsDisabled && name == null) {
                    throw new AssertionError();
                }
                World w = Bukkit.getWorld((String)name);
                if (w == null) {
                    throw new StreamCorruptedException("Missing world " + name);
                }
                return w;
            }

            @Override
            @Nullable
            public World deserialize(String s) {
                return Bukkit.getWorld((String)s);
            }

            @Override
            public boolean mustSyncDeserialization() {
                return true;
            }
        }));
        Classes.registerClass(new ClassInfo<Inventory>(Inventory.class, "inventory").user("inventor(y|ies)").name("Inventory").description("An inventory of a <a href='#player'>player</a> or <a href='#block'>block</a>. Inventories have many effects and conditions regarding the items contained.", "An inventory has a fixed amount of <a href='#slot'>slots</a> which represent a specific place in the inventory, e.g. the <a href='expressions.html#ExprArmorSlot'>helmet slot</a> for players (Please note that slot support is still very limited but will be improved eventually).").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Inventory>(Inventory.class)).parser(new Parser<Inventory>(){

            @Override
            @Nullable
            public Inventory parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Inventory i, int flags) {
                return "inventory of " + Classes.toString(i.getHolder());
            }

            @Override
            public String getDebugMessage(Inventory i) {
                return "inventory of " + Classes.getDebugMessage(i.getHolder());
            }

            @Override
            public String toVariableNameString(Inventory i) {
                return "inventory of " + Classes.toString(i.getHolder(), StringMode.VARIABLE_NAME);
            }

            @Override
            public String getVariableNamePattern() {
                return "inventory of .+";
            }
        }).changer(DefaultChangers.inventoryChanger));
        Classes.registerClass(new ClassInfo<InventoryAction>(InventoryAction.class, "inventoryaction").user("inventory ?actions?").name("Inventory Action").description("What player just did in inventory event. Note that when in creative game mode, most actions do not work correctly.").usage(InventoryActions.getAllNames()).examples("").since("2.2-dev16").defaultExpression(new EventValueExpression<InventoryAction>(InventoryAction.class)).parser(new Parser<InventoryAction>(){

            @Override
            @Nullable
            public InventoryAction parse(String s, ParseContext context) {
                return InventoryActions.parse(s);
            }

            @Override
            public String toString(InventoryAction o, int flags) {
                return InventoryActions.toString(o, flags);
            }

            @Override
            public String toVariableNameString(InventoryAction o) {
                return o.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        final EnumUtils<ClickType> invClicks = new EnumUtils<ClickType>(ClickType.class, "click types");
        Classes.registerClass(new ClassInfo<ClickType>(ClickType.class, "clicktype").user("click ?types?").name("Click Type").description("Click type, mostly for inventory events. Tells exactly which keys/buttons player pressed, assuming that default keybindings are used in client side.").usage(invClicks.getAllNames()).examples("").since("2.2-dev16b, 2.2-dev35 (renamed to click type)").defaultExpression(new EventValueExpression<ClickType>(ClickType.class)).parser(new Parser<ClickType>(){

            @Override
            @Nullable
            public ClickType parse(String s, ParseContext context) {
                return (ClickType)invClicks.parse(s);
            }

            @Override
            public String toString(ClickType o, int flags) {
                return invClicks.toString(o, flags);
            }

            @Override
            public String toVariableNameString(ClickType o) {
                return o.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        final EnumUtils<InventoryType> invTypes = new EnumUtils<InventoryType>(InventoryType.class, "inventory types");
        Classes.registerClass(new ClassInfo<InventoryType>(InventoryType.class, "inventorytype").user("inventory ?types?").name("Inventory Type").description("Minecraft has several different inventory types with their own use cases.").usage(invTypes.getAllNames()).examples("").since("2.2-dev32").defaultExpression(new EventValueExpression<InventoryType>(InventoryType.class)).parser(new Parser<InventoryType>(){

            @Override
            @Nullable
            public InventoryType parse(String s, ParseContext context) {
                return (InventoryType)invTypes.parse(s);
            }

            @Override
            public String toString(InventoryType o, int flags) {
                return invTypes.toString(o, flags);
            }

            @Override
            public String toVariableNameString(InventoryType o) {
                return o.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        Classes.registerClass(new ClassInfo<Player>(Player.class, "player").user("players?").name("Player").description("A player. Depending on whether a player is online or offline several actions can be performed with them, though you won't get any errors when using effects that only work if the player is online (e.g. changing his inventory) on an offline player.", "You have two possibilities to use players as command arguments: &lt;player&gt; and &lt;offline player&gt;. The first requires that the player is online and also accepts only part of the name, while the latter doesn't require that the player is online, but the player's name has to be entered exactly.").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Player>(Player.class)).after("string", "world").parser(new Parser<Player>(){

            @Override
            @Nullable
            public Player parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    if (s.matches("(?i)[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}")) {
                        return Bukkit.getPlayer((UUID)UUID.fromString(s));
                    }
                    List ps = Bukkit.matchPlayer((String)s);
                    if (ps.size() == 1) {
                        return (Player)ps.get(0);
                    }
                    if (ps.size() == 0) {
                        Skript.error(String.format(Language.get("commands.no player starts with"), s));
                    } else {
                        Skript.error(String.format(Language.get("commands.multiple players start with"), s));
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND;
            }

            @Override
            public String toString(Player p, int flags) {
                return p.getName();
            }

            @Override
            public String toVariableNameString(Player p) {
                if (SkriptConfig.usePlayerUUIDsInVariableNames.value().booleanValue()) {
                    return "" + p.getUniqueId();
                }
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                if (SkriptConfig.usePlayerUUIDsInVariableNames.value().booleanValue()) {
                    return "[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}";
                }
                return "\\S+";
            }

            @Override
            public String getDebugMessage(Player p) {
                return String.valueOf(p.getName()) + " " + Classes.getDebugMessage(p.getLocation());
            }
        }).changer(DefaultChangers.playerChanger).serializeAs(OfflinePlayer.class));
        Classes.registerClass(new ClassInfo<OfflinePlayer>(OfflinePlayer.class, "offlineplayer").user("offline ?players?").name("Offline Player").description("A player that is possibly offline. See <a href='#player'>player</a> for more information. Please note that while all effects and conditions that require a player can be used with an offline player as well, they will not work if the player is not actually online.").usage("").examples("").since("").defaultExpression(new EventValueExpression<OfflinePlayer>(OfflinePlayer.class)).after("string", "world").parser(new Parser<OfflinePlayer>(){

            @Override
            @Nullable
            public OfflinePlayer parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    if (s.matches("(?i)[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}")) {
                        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(s));
                    }
                    if (!s.matches("\\S+") || s.length() > 16) {
                        return null;
                    }
                    return Bukkit.getOfflinePlayer((String)s);
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND;
            }

            @Override
            public String toString(OfflinePlayer p, int flags) {
                return p.getName();
            }

            @Override
            public String toVariableNameString(OfflinePlayer p) {
                if (SkriptConfig.usePlayerUUIDsInVariableNames.value().booleanValue()) {
                    return "" + p.getUniqueId();
                }
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                if (SkriptConfig.usePlayerUUIDsInVariableNames.value().booleanValue()) {
                    return "[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}";
                }
                return "\\S+";
            }

            @Override
            public String getDebugMessage(OfflinePlayer p) {
                if (p.isOnline()) {
                    return Classes.getDebugMessage(p.getPlayer());
                }
                return p.getName();
            }
        }).serializer(new Serializer<OfflinePlayer>(){
            private final boolean uuidSupported = Skript.methodExists(OfflinePlayer.class, "getUniqueId", new Class[0]);

            @Override
            public Fields serialize(OfflinePlayer p) {
                Fields f = new Fields();
                if (this.uuidSupported) {
                    f.putObject("uuid", p.getUniqueId());
                }
                f.putObject("name", p.getName());
                return f;
            }

            @Override
            public void deserialize(OfflinePlayer o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            protected OfflinePlayer deserialize(Fields fields) throws StreamCorruptedException {
                OfflinePlayer p;
                if (fields.contains("uuid") && this.uuidSupported) {
                    OfflinePlayer p2;
                    UUID uuid = fields.getObject("uuid", UUID.class);
                    if (uuid == null || (p2 = Bukkit.getOfflinePlayer((UUID)uuid)) == null) {
                        throw new StreamCorruptedException();
                    }
                    return p2;
                }
                String name = fields.getObject("name", String.class);
                if (name == null || (p = Bukkit.getOfflinePlayer((String)name)) == null) {
                    throw new StreamCorruptedException();
                }
                return p;
            }

            @Override
            @Nullable
            public OfflinePlayer deserialize(String s) {
                return Bukkit.getOfflinePlayer((String)s);
            }

            @Override
            public boolean mustSyncDeserialization() {
                return true;
            }
        }));
        Classes.registerClass(new ClassInfo<CommandSender>(CommandSender.class, "commandsender").user("((commands?)? ?)?(sender|executor)s?").name("Command Sender").description("A player or the console.").usage("use <a href='expressions.html#LitConsole'>the console</a> for the console", "see <a href='#player'>player</a> for players.").examples("on command /pm:", "\tcommand sender is not the console", "\tchance of 10%", "\tgive coal to the player", "\tmessage \"You got a piece of coal for sending that PM!\"").since("1.0").defaultExpression(new EventValueExpression<CommandSender>(CommandSender.class)).parser(new Parser<CommandSender>(){

            @Override
            @Nullable
            public CommandSender parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(CommandSender s, int flags) {
                return s.getName();
            }

            @Override
            public String toVariableNameString(CommandSender s) {
                return s.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        Classes.registerClass(new ClassInfo<InventoryHolder>(InventoryHolder.class, "inventoryholder").name(ClassInfo.NO_DOC).defaultExpression(new EventValueExpression<InventoryHolder>(InventoryHolder.class)).after("entity", "block").parser(new Parser<InventoryHolder>(){

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(InventoryHolder holder, int flags) {
                return Classes.toString(holder instanceof BlockState ? ((BlockState)holder).getBlock() : holder);
            }

            @Override
            public String toVariableNameString(InventoryHolder holder) {
                return this.toString(holder, 0);
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Classes.registerClass(new ClassInfo<GameMode>(GameMode.class, "gamemode").user("game ?modes?").name("Game Mode").description("The game modes survival, creative and adventure.").usage("creative/survival/adventure").examples("player's gamemode is survival", "set the player argument's game mode to creative").since("1.0").defaultExpression(new SimpleLiteral<GameMode>(GameMode.SURVIVAL, true)).parser(new Parser<GameMode>(){
            private final Message[] names = new Message[GameMode.values().length];
            {
                int i = 0;
                GameMode[] gameModeArray = GameMode.values();
                int n = gameModeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GameMode m = gameModeArray[n2];
                    this.names[i++] = new Message("game modes." + m.name());
                    ++n2;
                }
            }

            @Override
            @Nullable
            public GameMode parse(String s, ParseContext context) {
                int i = 0;
                while (i < this.names.length) {
                    if (s.equalsIgnoreCase(this.names[i].toString())) {
                        return GameMode.values()[i];
                    }
                    ++i;
                }
                return null;
            }

            @Override
            public String toString(GameMode m, int flags) {
                return this.names[m.ordinal()].toString();
            }

            @Override
            public String toVariableNameString(GameMode o) {
                return o.toString().toLowerCase(Locale.ENGLISH);
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z]+";
            }
        }).serializer(new EnumSerializer<GameMode>(GameMode.class)));
        Classes.registerClass(new ClassInfo<ItemStack>(ItemStack.class, "itemstack").user("item", "material").name("Item / Material").description("An item, e.g. a stack of torches, a furnace, or a wooden sword of sharpness 2. Unlike <a href='#itemtype'>item type</a> an item can only represent exactly one item (e.g. an upside-down cobblestone stair facing west), while an item type can represent a whole range of items (e.g. any cobble stone stairs regardless of direction).", "You don't usually need this type except when you want to make a command that only accepts an exact item.", "Please note that currently 'material' is exactly the same as 'item', i.e. can have an amount & enchantments.").usage("<code>[&lt;number&gt; [of]] &lt;alias&gt; [of &lt;enchantment&gt; &lt;level&gt;]</code>, Where &lt;alias&gt; must be an alias that represents exactly one item (i.e cannot be a general alias like 'sword' or 'plant')").examples("set {_item} to type of the targeted block", "{_item} is a torch").since("1.0").after("number").parser(new Parser<ItemStack>(){

            @Override
            @Nullable
            public ItemStack parse(String s, ParseContext context) {
                ItemType t = Aliases.parseItemType(s);
                if (t == null) {
                    return null;
                }
                if ((t = t.getItem()).numTypes() != 1) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                ItemStack i = t.getRandom();
                if (!$assertionsDisabled && i == null) {
                    throw new AssertionError();
                }
                return i;
            }

            @Override
            public String toString(ItemStack i, int flags) {
                return ItemType.toString(i, flags);
            }

            @Override
            public String toVariableNameString(ItemStack i) {
                StringBuilder b = new StringBuilder("item:");
                b.append(i.getType().name());
                b.append(":" + ItemUtils.getDamage(i));
                b.append("*" + i.getAmount());
                for (Map.Entry entry : i.getEnchantments().entrySet()) {
                    b.append("#" + EnchantmentUtils.getKey((Enchantment)entry.getKey())).append(":" + entry.getValue());
                }
                return b.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "item:.+";
            }
        }).serializer(new ConfigurationSerializer()));
        Classes.registerClass(new ClassInfo<Item>(Item.class, "itementity").name(ClassInfo.NO_DOC).since("2.0").changer(DefaultChangers.itemChanger));
        Classes.registerClass(new ClassInfo<Biome>(Biome.class, "biome").user("biomes?").name("Biome").description("All possible biomes Minecraft uses to generate a world.").usage(BiomeUtils.getAllNames()).examples("biome at the player is desert").since("1.4.4").after("damagecause").parser(new Parser<Biome>(){

            @Override
            @Nullable
            public Biome parse(String s, ParseContext context) {
                return BiomeUtils.parse(s);
            }

            @Override
            public String toString(Biome b, int flags) {
                return BiomeUtils.toString(b, flags);
            }

            @Override
            public String toVariableNameString(Biome b) {
                return b.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new EnumSerializer<Biome>(Biome.class)));
        Classes.registerClass(new ClassInfo<PotionEffectType>(PotionEffectType.class, "potioneffecttype").user("potion( ?effect)?( ?type)?s?").name("Potion Effect Type").description("A potion effect type, e.g. 'strength' or 'swiftness'.").usage(StringUtils.join(PotionEffectUtils.getNames(), ", ")).examples("apply swiftness 5 to the player", "apply potion of speed 2 to the player for 60 seconds", "remove invisibility from the victim").since("").parser(new Parser<PotionEffectType>(){

            @Override
            @Nullable
            public PotionEffectType parse(String s, ParseContext context) {
                return PotionEffectUtils.parseType(s);
            }

            @Override
            public String toString(PotionEffectType p, int flags) {
                return PotionEffectUtils.toString(p, flags);
            }

            @Override
            public String toVariableNameString(PotionEffectType p) {
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<PotionEffectType>(){

            @Override
            public Fields serialize(PotionEffectType o) {
                Fields f = new Fields();
                f.putObject("name", o.getName());
                return f;
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            public void deserialize(PotionEffectType o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            protected PotionEffectType deserialize(Fields fields) throws StreamCorruptedException {
                String name = fields.getObject("name", String.class);
                if (!$assertionsDisabled && name == null) {
                    throw new AssertionError();
                }
                PotionEffectType t = PotionEffectType.getByName((String)name);
                if (t == null) {
                    throw new StreamCorruptedException("Invalid PotionEffectType " + name);
                }
                return t;
            }

            @Override
            @Nullable
            public PotionEffectType deserialize(String s) {
                return PotionEffectType.getByName((String)s);
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }));
        Classes.registerClass(new ClassInfo<EntityDamageEvent.DamageCause>(EntityDamageEvent.DamageCause.class, "damagecause").user("damage ?causes?").name("Damage Cause").description("The cause/type of a <a href='events.html#damage'>damage event</a>, e.g. lava, fall, fire, drowning, explosion, poison, etc.", "Please note that support for this type is very rudimentary, e.g. lava, fire and burning, as well as projectile and attack are considered different types.").usage(DamageCauseUtils.getAllNames()).examples("").since("2.0").defaultExpression(new ExprDamageCause()).after("itemtype", "itemstack", "entitydata", "entitytype").parser(new Parser<EntityDamageEvent.DamageCause>(){

            @Override
            @Nullable
            public EntityDamageEvent.DamageCause parse(String s, ParseContext context) {
                return DamageCauseUtils.parse(s);
            }

            @Override
            public String toString(EntityDamageEvent.DamageCause d, int flags) {
                return DamageCauseUtils.toString(d, flags);
            }

            @Override
            public String toVariableNameString(EntityDamageEvent.DamageCause d) {
                return d.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z0-9_-]+";
            }
        }).serializer(new EnumSerializer<EntityDamageEvent.DamageCause>(EntityDamageEvent.DamageCause.class)));
        Classes.registerClass(new ClassInfo<Chunk>(Chunk.class, "chunk").user("chunks?").name("Chunk").description("A chunk is a cuboid of 16\u00d716\u00d7128 (x\u00d7z\u00d7y) blocks. Chunks are spread on a fixed rectangular grid in their world.").usage("").examples("").since("2.0").parser(new Parser<Chunk>(){

            @Override
            @Nullable
            public Chunk parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Chunk c, int flags) {
                return "chunk (" + c.getX() + "," + c.getZ() + ") of " + c.getWorld().getName();
            }

            @Override
            public String toVariableNameString(Chunk c) {
                return String.valueOf(c.getWorld().getName()) + ":" + c.getX() + "," + c.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+:-?[0-9]+,-?[0-9]+";
            }
        }).serializer(new Serializer<Chunk>(){

            @Override
            public Fields serialize(Chunk c) {
                Fields f = new Fields();
                f.putObject("world", c.getWorld());
                f.putPrimitive("x", c.getX());
                f.putPrimitive("z", c.getZ());
                return f;
            }

            @Override
            public void deserialize(Chunk o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            protected Chunk deserialize(Fields fields) throws StreamCorruptedException {
                Chunk c;
                World w = fields.getObject("world", World.class);
                int x = fields.getPrimitive("x", Integer.TYPE);
                int z = fields.getPrimitive("z", Integer.TYPE);
                if (w == null || (c = w.getChunkAt(x, z)) == null) {
                    throw new StreamCorruptedException();
                }
                return c;
            }

            @Override
            @Nullable
            public Chunk deserialize(String s) {
                String[] split = s.split("[:,]");
                if (split.length != 3) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    int x = Integer.parseInt(split[1]);
                    int z = Integer.parseInt(split[1]);
                    return w.getChunkAt(x, z);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return true;
            }
        }));
        Classes.registerClass(new ClassInfo<Enchantment>(Enchantment.class, "enchantment").user("enchantments?").name("Enchantment").description("An enchantment, e.g. 'sharpness' or 'furtune'. Unlike <a href='#enchantmenttype'>enchantment type</a> this type has no level, but you usually don't need to use this type anyway.").usage(StringUtils.join(EnchantmentType.getNames(), ", ")).examples("").since("1.4.6").before("enchantmenttype").parser(new Parser<Enchantment>(){

            @Override
            @Nullable
            public Enchantment parse(String s, ParseContext context) {
                return EnchantmentType.parseEnchantment(s);
            }

            @Override
            public String toString(Enchantment e, int flags) {
                return EnchantmentType.toString(e, flags);
            }

            @Override
            public String toVariableNameString(Enchantment e) {
                return EnchantmentUtils.getKey(e);
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<Enchantment>(){

            @Override
            public Fields serialize(Enchantment ench) {
                Fields f = new Fields();
                f.putObject("key", EnchantmentUtils.getKey(ench));
                return f;
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            public void deserialize(Enchantment o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            protected Enchantment deserialize(Fields fields) throws StreamCorruptedException {
                String key = fields.getObject("key", String.class);
                if (!$assertionsDisabled && key == null) {
                    throw new AssertionError();
                }
                Enchantment e = EnchantmentUtils.getByKey(key);
                if (e == null) {
                    throw new StreamCorruptedException("Invalid enchantment " + key);
                }
                return e;
            }

            @Override
            @Nullable
            public Enchantment deserialize(String s) {
                return Enchantment.getByName((String)s);
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }));
        final Material[] allMaterials = Material.values();
        Classes.registerClass(new ClassInfo<Material>(Material.class, "material").name(ClassInfo.NO_DOC).since("aliases-rework").serializer(new Serializer<Material>(){

            @Override
            public Fields serialize(Material o) {
                Fields f = new Fields();
                f.putObject("i", o.ordinal());
                return f;
            }

            @Override
            public void deserialize(Material o, Fields f) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public Material deserialize(Fields f) throws StreamCorruptedException {
                Material mat = allMaterials[(Integer)f.getPrimitive("i")];
                if (!$assertionsDisabled && mat == null) {
                    throw new AssertionError();
                }
                return mat;
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }

            @Override
            protected boolean canBeInstantiated() {
                return false;
            }
        }));
        Classes.registerClass(new ClassInfo<Metadatable>(Metadatable.class, "metadataholder").user("metadata ?holders?").name("Metadata Holder").description("Something that can hold metadata (e.g. an entity or block)").examples("set metadata value \"super cool\" of player to true").since("2.2-dev36"));
        final EnumUtils<PlayerTeleportEvent.TeleportCause> teleportCauses = new EnumUtils<PlayerTeleportEvent.TeleportCause>(PlayerTeleportEvent.TeleportCause.class, "teleport causes");
        Classes.registerClass(new ClassInfo<PlayerTeleportEvent.TeleportCause>(PlayerTeleportEvent.TeleportCause.class, "teleportcause").user("teleport ?(cause|reason|type)s?").name("Teleport Cause").description("The teleport cause in a <a href='events.html#teleport'>teleport</a> event.").examples(teleportCauses.getAllNames()).since("2.2-dev35").parser(new Parser<PlayerTeleportEvent.TeleportCause>(){

            @Override
            public String toString(PlayerTeleportEvent.TeleportCause teleportCause, int flags) {
                return teleportCauses.toString(teleportCause, flags);
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toVariableNameString(PlayerTeleportEvent.TeleportCause teleportCause) {
                return teleportCause.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new EnumSerializer<PlayerTeleportEvent.TeleportCause>(PlayerTeleportEvent.TeleportCause.class)));
        final EnumUtils<CreatureSpawnEvent.SpawnReason> spawnReasons = new EnumUtils<CreatureSpawnEvent.SpawnReason>(CreatureSpawnEvent.SpawnReason.class, "spawn reasons");
        Classes.registerClass(new ClassInfo<CreatureSpawnEvent.SpawnReason>(CreatureSpawnEvent.SpawnReason.class, "spawnreason").user("spawn(ing)? ?reasons?").name("Spawn Reason").description("The spawn reason in a <a href='events.html#spawn'>spawn</a> event.").examples(spawnReasons.getAllNames()).since("2.3").parser(new Parser<CreatureSpawnEvent.SpawnReason>(){

            @Override
            public String toString(CreatureSpawnEvent.SpawnReason spawnReason, int flags) {
                return spawnReasons.toString(spawnReason, flags);
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toVariableNameString(CreatureSpawnEvent.SpawnReason spawnReason) {
                return spawnReason.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new EnumSerializer<CreatureSpawnEvent.SpawnReason>(CreatureSpawnEvent.SpawnReason.class)));
        if (Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent")) {
            Classes.registerClass(new ClassInfo<CachedServerIcon>(CachedServerIcon.class, "cachedservericon").user("server ?icons?").name("Server Icon").description("A server icon that was loaded using the <a href='effects.html#EffLoadServerIcon'>load server icon</a> effect.").examples("").since("2.3").parser(new Parser<CachedServerIcon>(){

                @Override
                @Nullable
                public CachedServerIcon parse(String s, ParseContext context) {
                    return null;
                }

                @Override
                public boolean canParse(ParseContext context) {
                    return false;
                }

                @Override
                public String toString(CachedServerIcon o, int flags) {
                    return "server icon";
                }

                @Override
                public String toVariableNameString(CachedServerIcon o) {
                    return "server icon";
                }

                @Override
                public String getVariableNamePattern() {
                    return "server icon";
                }
            }));
        }
        final EnumUtils<FireworkEffect.Type> fireworktypes = new EnumUtils<FireworkEffect.Type>(FireworkEffect.Type.class, "firework types");
        Classes.registerClass(new ClassInfo<FireworkEffect.Type>(FireworkEffect.Type.class, "fireworktype").user("firework ?types?").name("Firework Type").description("The type of a <a href='#fireworkeffect'>fireworkeffect</a>.").defaultExpression(new EventValueExpression<FireworkEffect.Type>(FireworkEffect.Type.class)).examples(fireworktypes.getAllNames()).since("2.4").parser(new Parser<FireworkEffect.Type>(){

            @Override
            @Nullable
            public FireworkEffect.Type parse(String input, ParseContext context) {
                return (FireworkEffect.Type)fireworktypes.parse(input);
            }

            @Override
            public String toString(FireworkEffect.Type type, int flags) {
                return fireworktypes.toString(type, flags);
            }

            @Override
            public String toVariableNameString(FireworkEffect.Type type) {
                return type.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new EnumSerializer<FireworkEffect.Type>(FireworkEffect.Type.class)));
        Classes.registerClass(new ClassInfo<FireworkEffect>(FireworkEffect.class, "fireworkeffect").user("firework ?effects?").name("Firework Effect").description("A configuration of effects that defines the firework when exploded.").defaultExpression(new EventValueExpression<FireworkEffect>(FireworkEffect.class)).since("2.4").parser(new Parser<FireworkEffect>(){

            @Override
            @Nullable
            public FireworkEffect parse(String input, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(FireworkEffect effect, int flags) {
                return "Firework effect " + effect.toString();
            }

            @Override
            public String toVariableNameString(FireworkEffect effect) {
                return "firework effect " + effect.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        final EnumUtils<Difficulty> difficulties = new EnumUtils<Difficulty>(Difficulty.class, "difficulties");
        Classes.registerClass(new ClassInfo<Difficulty>(Difficulty.class, "difficulty").user("difficult(y|ies)").name("Difficulty").description("The difficulty of a <a href='#world'>world</a>.").examples(difficulties.getAllNames()).since("2.3").parser(new Parser<Difficulty>(){

            @Override
            @Nullable
            public Difficulty parse(String input, ParseContext context) {
                return (Difficulty)difficulties.parse(input);
            }

            @Override
            public String toString(Difficulty difficulty, int flags) {
                return difficulties.toString(difficulty, flags);
            }

            @Override
            public String toVariableNameString(Difficulty difficulty) {
                return difficulty.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new EnumSerializer<Difficulty>(Difficulty.class)));
        final EnumUtils<PlayerResourcePackStatusEvent.Status> resourcePackStates = new EnumUtils<PlayerResourcePackStatusEvent.Status>(PlayerResourcePackStatusEvent.Status.class, "resource pack states");
        Classes.registerClass(new ClassInfo<PlayerResourcePackStatusEvent.Status>(PlayerResourcePackStatusEvent.Status.class, "resourcepackstate").user("resource ?pack ?states?").name("Resource Pack State").description("The state in a <a href='events.html#resource_pack_request_action'>resource pack request response</a> event.").examples(resourcePackStates.getAllNames()).since("2.4").parser(new Parser<PlayerResourcePackStatusEvent.Status>(){

            @Override
            public String toString(PlayerResourcePackStatusEvent.Status state, int flags) {
                return resourcePackStates.toString(state, flags);
            }

            @Override
            @Nullable
            public PlayerResourcePackStatusEvent.Status parse(String s, ParseContext context) {
                return (PlayerResourcePackStatusEvent.Status)resourcePackStates.parse(s);
            }

            @Override
            public String toVariableNameString(PlayerResourcePackStatusEvent.Status state) {
                return state.name();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new EnumSerializer<PlayerResourcePackStatusEvent.Status>(PlayerResourcePackStatusEvent.Status.class)));
        if (Skript.classExists("org.bukkit.SoundCategory")) {
            final EnumUtils<SoundCategory> soundCategories = new EnumUtils<SoundCategory>(SoundCategory.class, "sound categories");
            Classes.registerClass(new ClassInfo<SoundCategory>(SoundCategory.class, "soundcategory").user("sound ?categor(y|ies)").name("Sound Category").description("The category of a sound, they are used for sound options of Minecraft. See the <a href='effects.html#EffPlaySound'>play sound</a> and <a href='effects.html#EffStopSound'>stop sound</a> effects.").examples(soundCategories.getAllNames()).since("2.4").requiredPlugins("Minecraft 1.11 or newer").parser(new Parser<SoundCategory>(){

                @Override
                @Nullable
                public SoundCategory parse(String s, ParseContext context) {
                    return (SoundCategory)soundCategories.parse(s);
                }

                @Override
                public String toString(SoundCategory state, int flags) {
                    return soundCategories.toString(state, flags);
                }

                @Override
                public String toVariableNameString(SoundCategory category) {
                    return category.name();
                }

                @Override
                public String getVariableNamePattern() {
                    return "\\S+";
                }
            }).serializer(new EnumSerializer<SoundCategory>(SoundCategory.class)));
        }
        if (Skript.classExists("org.bukkit.entity.Panda$Gene")) {
            final EnumUtils<Panda.Gene> genes = new EnumUtils<Panda.Gene>(Panda.Gene.class, "genes");
            Classes.registerClass(new ClassInfo<Panda.Gene>(Panda.Gene.class, "gene").user("(panda )?genes?").name("Gene").description("Represents a Panda's main or hidden gene. Look at Panda's minecraft wiki on <a href='https://minecraft.gamepedia.com/Panda#Genetics'>genetics</a> for more info.").examples(genes.getAllNames()).since("2.4").requiredPlugins("Minecraft 1.14 or newer").parser(new Parser<Panda.Gene>(){

                @Override
                @Nullable
                public Panda.Gene parse(String expr, ParseContext context) {
                    return (Panda.Gene)genes.parse(expr);
                }

                @Override
                public String toString(Panda.Gene gene, int flags) {
                    return genes.toString(gene, flags);
                }

                @Override
                public String toVariableNameString(Panda.Gene gene) {
                    return gene.name();
                }

                @Override
                public String getVariableNamePattern() {
                    return "\\S+";
                }
            }).serializer(new EnumSerializer<Panda.Gene>(Panda.Gene.class)));
        }
    }
}

