/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.chat;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.chat.ChatCode;
import ch.njol.skript.util.chat.LinkParseMode;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.skript.util.chat.SkriptChatCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public class ChatMessages {
    public static LinkParseMode linkParseMode = LinkParseMode.DISABLED;
    public static boolean colorResetCodes = false;
    static final Map<String, ChatCode> codes = new HashMap<String, ChatCode>();
    static final Set<ChatCode> addonCodes = new HashSet<ChatCode>();
    static final ChatCode[] colorChars = new ChatCode[256];
    static final Pattern linkPattern = Pattern.compile("[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,6}\\b([-a-zA-Z0-9@:%_\\+.~#?&//=]*)");
    static final Gson gson;

    static {
        Gson nullableGson = new GsonBuilder().registerTypeAdapter(Boolean.TYPE, (Object)new MessageComponent.BooleanSerializer()).create();
        assert (nullableGson != null);
        gson = nullableGson;
    }

    public static void registerListeners() {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                codes.clear();
                Skript.debug("Parsing message style lang files");
                SkriptChatCode[] skriptChatCodeArray = SkriptChatCode.values();
                int n = skriptChatCodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SkriptChatCode skriptChatCode = skriptChatCodeArray[n2];
                    if (!$assertionsDisabled && skriptChatCode == null) {
                        throw new AssertionError();
                    }
                    ChatMessages.registerChatCode(skriptChatCode);
                    ++n2;
                }
                for (ChatCode chatCode : addonCodes) {
                    if (!$assertionsDisabled && chatCode == null) {
                        throw new AssertionError();
                    }
                    ChatMessages.registerChatCode(chatCode);
                }
                ChatMessages.addColorChar('k', SkriptChatCode.obfuscated);
                ChatMessages.addColorChar('l', SkriptChatCode.bold);
                ChatMessages.addColorChar('m', SkriptChatCode.strikethrough);
                ChatMessages.addColorChar('n', SkriptChatCode.underlined);
                ChatMessages.addColorChar('o', SkriptChatCode.italic);
                ChatMessages.addColorChar('r', SkriptChatCode.reset);
            }
        });
    }

    static void registerChatCode(ChatCode code) {
        String langName = code.getLangName();
        if (code.isLocalized()) {
            if (code.getColorCode() != null) {
                String[] stringArray = Language.getList("colors." + langName + ".names");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    codes.put(name, code);
                    ++n2;
                }
            } else {
                String[] stringArray = Language.getList("chat styles." + langName);
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String name = stringArray[n3];
                    codes.put(name, code);
                    ++n3;
                }
            }
        } else {
            codes.put(langName, code);
        }
        if (code.getColorChar() != '\u0000') {
            ChatMessages.addColorChar(code.getColorChar(), code);
        }
    }

    static void addColorChar(char code, ChatCode data) {
        ChatMessages.colorChars[code] = data;
        ChatMessages.colorChars[Character.toUpperCase((char)code)] = data;
    }

    /*
     * Unable to fully structure code
     */
    public static List<MessageComponent> parse(String msg) {
        chars = msg.toCharArray();
        components = new ArrayList<MessageComponent>();
        current = new MessageComponent();
        components.add(current);
        curStr = new StringBuilder();
        i = 0;
        while (i < chars.length) {
            block30: {
                block31: {
                    block29: {
                        block28: {
                            c = chars[i];
                            code = null;
                            param = "";
                            if (c != '<') break block28;
                            end = -1;
                            angleBrackets = 1;
                            j = i + 1;
                            while (j < chars.length) {
                                c2 = chars[j];
                                if (c2 == '<') {
                                    ++angleBrackets;
                                } else if (c2 == '>') {
                                    --angleBrackets;
                                }
                                if (angleBrackets == 0) {
                                    end = j;
                                    break;
                                }
                                ++j;
                            }
                            if (end == -1) break block29;
                            tag = msg.substring(i + 1, end);
                            if (tag.contains(":")) {
                                split = tag.split(":", 2);
                                name = split[0];
                                param = split[1];
                            } else {
                                name = tag;
                            }
                            code = ChatMessages.codes.get(name);
                            if (code == null) break block29;
                            text = curStr.toString();
                            curStr = new StringBuilder();
                            if (!ChatMessages.$assertionsDisabled && text == null) {
                                throw new AssertionError();
                            }
                            current.text = text;
                            old = current;
                            current = new MessageComponent();
                            components.add(current);
                            if (code.getColorCode() != null) {
                                current.color = code.getColorCode();
                            } else {
                                if (!ChatMessages.$assertionsDisabled && param == null) {
                                    throw new AssertionError();
                                }
                                code.updateComponent(current, param);
                            }
                            ChatMessages.copyStyles(old, current);
                            i = end;
                            break block30;
                        }
                        if (c != '&' && c != '\u00a7') break block29;
                        if (i == chars.length - 1) {
                            curStr.append(c);
                        } else {
                            color = chars[i + 1];
                            if (color >= ChatMessages.colorChars.length) {
                                curStr.append(c);
                            } else {
                                code = ChatMessages.colorChars[color];
                                if (code == null) {
                                    curStr.append(c).append(color);
                                } else {
                                    text = curStr.toString();
                                    curStr = new StringBuilder();
                                    if (!ChatMessages.$assertionsDisabled && text == null) {
                                        throw new AssertionError();
                                    }
                                    current.text = text;
                                    old = current;
                                    current = new MessageComponent();
                                    components.add(current);
                                    if (code.getColorCode() != null) {
                                        current.color = code.getColorCode();
                                    } else {
                                        code.updateComponent(current, param);
                                    }
                                    ChatMessages.copyStyles(old, current);
                                }
                                ++i;
                            }
                        }
                        break block30;
                    }
                    if (ChatMessages.linkParseMode != LinkParseMode.STRICT || c != 'h') break block31;
                    rest = msg.substring(i);
                    link = null;
                    if (rest.startsWith("http://") || rest.startsWith("https://")) {
                        link = rest.split(" ", 2)[0];
                    }
                    if (link == null || link.isEmpty()) ** GOTO lbl-1000
                    text = curStr.toString();
                    curStr = new StringBuilder();
                    if (!ChatMessages.$assertionsDisabled && text == null) {
                        throw new AssertionError();
                    }
                    current.text = text;
                    old = current;
                    current = new MessageComponent();
                    ChatMessages.copyStyles(old, current);
                    components.add(current);
                    SkriptChatCode.open_url.updateComponent(current, link);
                    current.text = link;
                    i += link.length() - 1;
                    current = new MessageComponent();
                    components.add(current);
                    break block30;
                }
                if (ChatMessages.linkParseMode != LinkParseMode.LENIENT || i != 0 && chars[i - 1] != ' ') ** GOTO lbl-1000
                rest = msg.substring(i);
                link = null;
                potentialLink = rest.split(" ", 2)[0];
                if (ChatMessages.linkPattern.matcher(potentialLink).matches()) {
                    link = potentialLink;
                }
                if (link != null && !link.isEmpty()) {
                    url = link.startsWith("http://") == false && link.startsWith("https://") == false ? "http://" + link : link;
                    text = curStr.toString();
                    curStr = new StringBuilder();
                    if (!ChatMessages.$assertionsDisabled && text == null) {
                        throw new AssertionError();
                    }
                    current.text = text;
                    old = current;
                    current = new MessageComponent();
                    ChatMessages.copyStyles(old, current);
                    components.add(current);
                    SkriptChatCode.open_url.updateComponent(current, url);
                    current.text = link;
                    i += link.length() - 1;
                    current = new MessageComponent();
                    components.add(current);
                } else lbl-1000:
                // 3 sources

                {
                    curStr.append(c);
                }
            }
            ++i;
        }
        text = curStr.toString();
        if (!ChatMessages.$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        current.text = text;
        return components;
    }

    public static MessageComponent[] parseToArray(String msg) {
        return ChatMessages.parse(msg).toArray(new MessageComponent[0]);
    }

    public static String toJson(String msg) {
        ComponentList componentList = new ComponentList(ChatMessages.parse(msg));
        String json = gson.toJson((Object)componentList);
        assert (json != null);
        return json;
    }

    public static String toJson(List<MessageComponent> components) {
        ComponentList componentList = new ComponentList(components);
        String json = gson.toJson((Object)componentList);
        assert (json != null);
        return json;
    }

    public static void copyStyles(MessageComponent from, MessageComponent to) {
        if (to.reset) {
            return;
        }
        if (to.color == null || !colorResetCodes) {
            if (!to.bold) {
                to.bold = from.bold;
            }
            if (!to.italic) {
                to.italic = from.italic;
            }
            if (!to.underlined) {
                to.underlined = from.underlined;
            }
            if (!to.strikethrough) {
                to.strikethrough = from.strikethrough;
            }
            if (!to.obfuscated) {
                to.obfuscated = from.obfuscated;
            }
            if (to.color == null) {
                to.color = from.color;
            }
        }
        if (to.clickEvent == null) {
            to.clickEvent = from.clickEvent;
        }
        if (to.insertion == null) {
            to.insertion = from.insertion;
        }
        if (to.hoverEvent == null) {
            to.hoverEvent = from.hoverEvent;
        }
    }

    public static void shareStyles(MessageComponent[] components) {
        MessageComponent previous = null;
        MessageComponent[] messageComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            MessageComponent c = messageComponentArray[n2];
            if (previous != null) {
                assert (c != null);
                ChatMessages.copyStyles(previous, c);
            }
            previous = c;
            ++n2;
        }
    }

    public static MessageComponent plainText(String str) {
        MessageComponent component = new MessageComponent();
        component.text = str;
        return component;
    }

    public static void registerAddonCode(@Nullable SkriptAddon addon, @Nullable ChatCode code) {
        Objects.requireNonNull(addon);
        Objects.requireNonNull(code);
        addonCodes.add(code);
        ChatMessages.registerChatCode(code);
    }

    public static String stripStyles(String text) {
        List<MessageComponent> components = ChatMessages.parse(text);
        StringBuilder sb = new StringBuilder();
        for (MessageComponent component : components) {
            sb.append(component.text);
        }
        String plain = sb.toString();
        assert (plain != null);
        return plain;
    }

    private static class ComponentList {
        @Deprecated
        public String text = "";
        @Nullable
        public List<MessageComponent> extra;

        public ComponentList(List<MessageComponent> components) {
            this.extra = components;
        }

        public ComponentList(MessageComponent[] components) {
            this.extra = Arrays.asList(components);
        }
    }
}

