/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Enchantments")
@Description(value={"All the enchantments an <a href='classes.html#itemtype'>item type</a> has."})
@Examples(value={"clear enchantments of event-item"})
@Since(value="2.2-dev36")
public class ExprEnchantments
extends SimpleExpression<EnchantmentType> {
    private Expression<ItemType> items;

    static {
        PropertyExpression.register(ExprEnchantments.class, EnchantmentType.class, "enchantments", "itemtypes");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        return true;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Nullable
    protected EnchantmentType[] get(Event e) {
        ArrayList enchantments = new ArrayList();
        ItemType[] itemTypeArray = this.items.getArray(e);
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType item = itemTypeArray[n2];
            EnchantmentType[] enchants = item.getEnchantmentTypes();
            if (enchants != null) {
                Collections.addAll(enchantments, enchants);
            }
            ++n2;
        }
        return enchantments.toArray(new EnchantmentType[0]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return CollectionUtils.array(Enchantment[].class, EnchantmentType[].class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType[] source = this.items.getArray(e);
        EnchantmentType[] enchants = new EnchantmentType[delta != null ? delta.length : 0];
        if (delta != null && delta.length != 0) {
            int i = 0;
            while (i < delta.length) {
                enchants[i] = delta[i] instanceof EnchantmentType ? (EnchantmentType)delta[i] : new EnchantmentType((Enchantment)delta[i]);
                ++i;
            }
        }
        switch (mode) {
            case ADD: {
                ItemType[] itemTypeArray = source;
                int n = source.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemType item = itemTypeArray[n2];
                    item.addEnchantments(enchants);
                    ++n2;
                }
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                ItemType[] itemTypeArray = source;
                int n = source.length;
                int n3 = 0;
                while (n3 < n) {
                    ItemType item = itemTypeArray[n3];
                    item.removeEnchantments(enchants);
                    ++n3;
                }
                break;
            }
            case SET: {
                ItemType[] itemTypeArray = source;
                int n = source.length;
                int n4 = 0;
                while (n4 < n) {
                    ItemType item = itemTypeArray[n4];
                    item.clearEnchantments();
                    item.addEnchantments(enchants);
                    ++n4;
                }
                break;
            }
            case DELETE: 
            case RESET: {
                ItemType[] itemTypeArray = source;
                int n = source.length;
                int n5 = 0;
                while (n5 < n) {
                    ItemType item = itemTypeArray[n5];
                    item.clearEnchantments();
                    ++n5;
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends EnchantmentType> getReturnType() {
        return EnchantmentType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the enchantments of " + this.items.toString(e, debug);
    }
}

