/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Coloured / Uncoloured")
@Description(value={"Parses &lt;colour&gt;s (including chat styles) in a message or removes any colours & chat styles from the message."})
@Examples(value={"on chat:", "\tset message to coloured message", "command /fade <player>:", "\ttrigger:", "\t\tset display name of the player-argument to uncoloured display name of the player-argument"})
@Since(value="2.0")
public class ExprColoured
extends PropertyExpression<String, String> {
    boolean color;

    static {
        Skript.registerExpression(ExprColoured.class, String.class, ExpressionType.COMBINED, "(colo[u]r-|colo[u]red )%strings%", "(un|non)[-](colo[u]r-|colo[u]red )%strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.color = matchedPattern == 0;
        return true;
    }

    protected String[] get(Event e, String[] source) {
        return this.get(source, new Converter<String, String>(){

            @Override
            public String convert(String s) {
                return ExprColoured.this.color ? Utils.replaceChatStyles(s) : ChatMessages.stripStyles(s);
            }
        });
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.color ? "" : "un") + "coloured " + this.getExpr().toString(e, debug);
    }
}

