/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Book Author")
@Description(value={"The author of a book."})
@Examples(value={"on book sign:", "\tmessage \"Book Title: %author of event-item%\""})
@Since(value="2.2-dev31")
public class ExprBookAuthor
extends SimplePropertyExpression<ItemStack, String> {
    private static final ItemType book;

    static {
        ExprBookAuthor.register(ExprBookAuthor.class, String.class, "[book] (author|writer|publisher)", "itemstack");
        book = Aliases.javaItemType("book with text");
    }

    @Override
    protected String getPropertyName() {
        return "author";
    }

    @Override
    @Nullable
    public String convert(ItemStack itemStack) {
        if (!book.isOfType(itemStack)) {
            return null;
        }
        return ((BookMeta)itemStack.getItemMeta()).getAuthor();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return CollectionUtils.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemStack itemStack = (ItemStack)this.getExpr().getSingle(e);
        if (itemStack == null || !book.isOfType(itemStack)) {
            return;
        }
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        switch (mode) {
            case SET: {
                bookMeta.setAuthor(delta == null ? "" : (String)delta[0]);
                break;
            }
            case DELETE: 
            case RESET: {
                bookMeta.setAuthor("");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        itemStack.setItemMeta((ItemMeta)bookMeta);
    }
}

