/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

@Name(value="Is Loaded")
@Description(value={"Checks whether or not a chunk/world is loaded"})
@Examples(value={"if chunk at {home::%player's uuid%} is loaded:"})
@Since(value="2.3")
public class CondIsLoaded
extends PropertyCondition<Object> {
    static {
        CondIsLoaded.register(CondIsLoaded.class, "loaded", "worlds/chunks");
    }

    @Override
    public boolean check(Object o) {
        if (o instanceof Chunk) {
            return ((Chunk)o).isLoaded();
        }
        if (o instanceof World) {
            return Bukkit.getWorld((String)((World)o).getName()) != null;
        }
        return false;
    }

    @Override
    protected String getPropertyName() {
        return "loaded";
    }
}

