/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value=false)
public class BurgerHelper {
    private static MethodHandle typeIdMethod;
    public Burger burger;

    static {
        try {
            MethodHandle mh;
            typeIdMethod = mh = MethodHandles.lookup().findVirtual(Material.class, "getId", MethodType.methodType(Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            typeIdMethod = null;
        }
    }

    public BurgerHelper(String data) {
        if (typeIdMethod == null) {
            throw new IllegalStateException("requires Minecraft 1.12.2 or older");
        }
        this.burger = ((Burger[])new Gson().fromJson(data, Burger[].class))[0];
    }

    public Map<String, Material> mapMaterials() {
        HashMap<String, Material> materials = new HashMap<String, Material>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id;
            Material material = materialArray[n2];
            try {
                id = typeIdMethod.invokeExact(material);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            String vanillaId = null;
            for (ItemOrBlock item : this.burger.items.item.values()) {
                if (item.numeric_id != id) continue;
                vanillaId = item.text_id;
                break;
            }
            for (ItemOrBlock block : this.burger.blocks.block.values()) {
                if (block.numeric_id != id) continue;
                vanillaId = block.text_id;
                break;
            }
            materials.put(vanillaId, material);
            ++n2;
        }
        return materials;
    }

    public static Map<Integer, Material> mapIds() {
        if (typeIdMethod == null) {
            throw new IllegalStateException("requires Minecraft 1.12.2 or older");
        }
        HashMap<Integer, Material> ids = new HashMap<Integer, Material>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            try {
                ids.put(typeIdMethod.invokeExact(mat), mat);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return ids;
    }

    public static class Blocks {
        public Map<String, ItemOrBlock> block;
    }

    public static class Burger {
        public Items items;
        public Blocks blocks;
        public Source source;
    }

    public static class ItemOrBlock {
        public String text_id;
        public int numeric_id;
        public String display_name;
    }

    public static class Items {
        public Map<String, ItemOrBlock> item;
    }

    public static class Source {
        public String file;
    }
}

