/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Chat Recipients")
@Description(value={"Recipients of chat events where this is called."})
@Examples(value={"chat recipients"})
@Since(value="2.2-Fixes-v7, 2.2-dev35 (clearing recipients)")
public class ExprChatRecipients
extends SimpleExpression<Player> {
    static {
        Skript.registerExpression(ExprChatRecipients.class, Player.class, ExpressionType.SIMPLE, "[chat][( |-)]recipients");
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<Player> getReturnType() {
        return Player.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return CollectionUtils.array(Player[].class);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(AsyncPlayerChatEvent.class)) {
            Skript.error("Cannot use chat recipients expression outside of a chat event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "chat recipients";
    }

    @Nullable
    protected Player[] get(Event event) {
        AsyncPlayerChatEvent ae = (AsyncPlayerChatEvent)event;
        Set playerSet = ae.getRecipients();
        return playerSet.toArray(new Player[playerSet.size()]);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Player[] recipients = (Player[])delta;
        switch (mode) {
            case REMOVE: {
                assert (recipients != null);
                Player[] playerArray = recipients;
                int n = recipients.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    ((AsyncPlayerChatEvent)event).getRecipients().remove(player);
                    ++n2;
                }
                break;
            }
            case ADD: {
                assert (recipients != null);
                Player[] playerArray = recipients;
                int n = recipients.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    ((AsyncPlayerChatEvent)event).getRecipients().add(player);
                    ++n3;
                }
                break;
            }
            case SET: {
                this.change(event, delta, Changer.ChangeMode.DELETE);
                this.change(event, delta, Changer.ChangeMode.ADD);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                ((AsyncPlayerChatEvent)event).getRecipients().clear();
            }
        }
    }
}

