/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.aliases.InvalidMinecraftIdException;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.aliases.MaterialName;
import ch.njol.skript.bukkitutil.BukkitUnsafe;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockValues;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.localization.Noun;
import ch.njol.util.NonNullPair;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class AliasesProvider {
    private final Map<String, ItemType> aliases;
    private final Map<ItemData, MaterialName> materialNames;
    private final Gson gson;
    private final Map<String, VariationGroup> variations;
    private final Map<ItemData, String> minecraftIds;
    private final Map<ItemData, EntityData<?>> relatedEntities;

    public AliasesProvider(int expectedCount) {
        this.aliases = new HashMap<String, ItemType>(expectedCount);
        this.materialNames = new HashMap<ItemData, MaterialName>(expectedCount);
        this.variations = new HashMap<String, VariationGroup>(expectedCount / 20);
        this.minecraftIds = new HashMap<ItemData, String>(3000);
        this.relatedEntities = new HashMap(10);
        this.gson = new Gson();
    }

    public Map<String, Object> parseMojangson(String raw) {
        return (Map)this.gson.fromJson(raw, Object.class);
    }

    public boolean applyTags(ItemStack stack, Map<String, Object> tags) {
        Object damage = tags.get("Damage");
        boolean appliedDamage = false;
        if (damage instanceof Number) {
            ItemUtils.setDamage(stack, ((Number)damage).shortValue());
            tags.remove("Damage");
            appliedDamage = true;
        }
        if (tags.isEmpty()) {
            return appliedDamage;
        }
        String json = this.gson.toJson(tags);
        assert (json != null);
        BukkitUnsafe.modifyItemStack(stack, json);
        return true;
    }

    public NonNullPair<String, String> getAliasPlural(String name) {
        int marker = name.indexOf(166);
        if (marker == -1) {
            String trimmed = name.trim();
            assert (trimmed != null);
            return new NonNullPair<String, String>(trimmed, trimmed);
        }
        int pluralEnd = -1;
        int i = marker;
        while (i < name.length()) {
            int c = name.codePointAt(i);
            if (Character.isWhitespace(c)) {
                pluralEnd = i;
                break;
            }
            i += Character.charCount(c);
            ++i;
        }
        if (pluralEnd == -1) {
            String singular = name.substring(0, marker);
            String plural = String.valueOf(singular) + name.substring(marker + 1);
            singular = singular.trim();
            plural = plural.trim();
            assert (singular != null);
            assert (plural != null);
            return new NonNullPair<String, String>(singular, plural);
        }
        String base = name.substring(0, marker);
        String singular = String.valueOf(base) + name.substring(pluralEnd);
        String plural = String.valueOf(base) + name.substring(marker + 1);
        singular = singular.trim();
        plural = plural.trim();
        assert (singular != null);
        assert (plural != null);
        return new NonNullPair<String, String>(singular, plural);
    }

    public void addAlias(String name, String id, @Nullable Map<String, Object> tags, Map<String, String> blockStates) {
        List<ItemData> datas;
        ItemType typeOfId = this.aliases.get(id);
        EntityData<?> related = null;
        if (typeOfId != null) {
            datas = typeOfId.getTypes();
        } else {
            Material material = BukkitUnsafe.getMaterialFromMinecraftId(id);
            if (material == null) {
                throw new InvalidMinecraftIdException(id);
            }
            String entityName = blockStates.remove("relatedEntity");
            if (entityName != null) {
                related = EntityData.parse(entityName);
            }
            ItemStack stack = new ItemStack(material);
            boolean modifiedStack = false;
            if (tags != null) {
                modifiedStack = this.applyTags(stack, new HashMap<String, Object>(tags));
            }
            BlockValues blockValues = BlockCompat.INSTANCE.createBlockValues(material, blockStates, stack, modifiedStack);
            ItemData data = new ItemData(stack, blockValues);
            data.isAlias = true;
            data.modifiedStack = modifiedStack;
            datas = Collections.singletonList(data);
        }
        NonNullPair<String, Integer> plain = Noun.stripGender(name, name);
        NonNullPair<String, String> forms = this.getAliasPlural(plain.getFirst());
        ItemType type = this.aliases.get(forms.getFirst());
        if (type == null) {
            type = this.aliases.get(forms.getSecond());
        }
        if (type == null) {
            type = new ItemType();
            this.aliases.put(forms.getFirst(), type);
            this.aliases.put(forms.getSecond(), type);
        }
        assert (datas != null);
        type.addAll(datas);
        for (ItemData data : type.getTypes()) {
            data.strictEquality = true;
            if (typeOfId == null) {
                this.minecraftIds.put(data, id);
            }
            this.materialNames.putIfAbsent(data, new MaterialName(data.type, forms.getFirst(), forms.getSecond(), plain.getSecond()));
            if (related != null) {
                this.relatedEntities.put(data, related);
            }
            data.strictEquality = false;
        }
    }

    public void addVariationGroup(String name, VariationGroup group) {
        this.variations.put(name, group);
    }

    @Nullable
    public VariationGroup getVariationGroup(String name) {
        return this.variations.get(name);
    }

    @Nullable
    public ItemType getAlias(String alias) {
        return this.aliases.get(alias);
    }

    @Nullable
    public String getMinecraftId(ItemData data) {
        String id = this.minecraftIds.get(data);
        if (id == null) {
            ItemData defaultData = data.clone();
            defaultData.blockValues = null;
            id = this.minecraftIds.get(defaultData);
        }
        return id;
    }

    @Nullable
    public MaterialName getMaterialName(ItemData data) {
        MaterialName name = this.materialNames.get(data);
        if (name == null) {
            ItemData defaultData = data.clone();
            defaultData.blockValues = null;
            name = this.materialNames.get(defaultData);
        }
        return name;
    }

    public void setMaterialName(ItemData data, MaterialName materialName) {
        this.materialNames.put(data, materialName);
    }

    public void clearAliases() {
        this.aliases.clear();
        this.materialNames.clear();
        this.variations.clear();
    }

    public int getAliasCount() {
        return this.aliases.size();
    }

    @Nullable
    public EntityData<?> getRelatedEntity(ItemData type) {
        return this.relatedEntities.get(type);
    }

    public static class Variation {
        @Nullable
        private final String id;
        private final int insertPoint;
        private final Map<String, Object> tags;
        private final Map<String, String> states;

        public Variation(@Nullable String id, int insertPoint, Map<String, Object> tags, Map<String, String> states) {
            this.id = id;
            this.insertPoint = insertPoint;
            this.tags = tags;
            this.states = states;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public int getInsertPoint() {
            return this.insertPoint;
        }

        @Nullable
        public String insertId(@Nullable String inserted) {
            if (this.id == null) {
                return inserted;
            }
            if (inserted == null) {
                return this.id;
            }
            inserted = inserted.substring(0, inserted.length() - 1);
            String id = this.id;
            assert (id != null);
            if (this.insertPoint == -1) {
                return inserted;
            }
            String before = id.substring(0, this.insertPoint);
            String after = id.substring(this.insertPoint + 1);
            return String.valueOf(before) + inserted + after;
        }

        public Map<String, Object> getTags() {
            return this.tags;
        }

        public Map<String, String> getBlockStates() {
            return this.states;
        }

        public Variation merge(Variation other) {
            HashMap<String, Object> mergedTags = new HashMap<String, Object>(other.tags);
            mergedTags.putAll(this.tags);
            HashMap<String, String> mergedStates = new HashMap<String, String>(other.states);
            mergedStates.putAll(this.states);
            String id = this.insertId(other.id);
            return new Variation(id, -1, mergedTags, mergedStates);
        }
    }

    public static class VariationGroup {
        public final List<String> keys = new ArrayList<String>();
        public final List<Variation> values = new ArrayList<Variation>();

        public void put(String key, Variation value) {
            this.keys.add(key);
            this.values.add(value);
        }
    }
}

