/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Yaw and pitch")
@Description(value={"Gets or sets the yaw or pitch value of a vector."})
@Examples(value={"set {_v} to vector -1, 1, 1", "send \"%vector yaw of {_v}%, %vector pitch of {_v}%\"", "add 45 to vector yaw of {_v}", "subtract 45 from vector pitch of {_v}", "send \"%vector yaw of {_v}%, %vector pitch of {_v}%\"", "set vector yaw of {_v} to -45", "set vector pitch of {_v} to 45", "send \"%vector yaw of {_v}%, %vector pitch of {_v}%\""})
@Since(value="2.2-dev28")
public class ExprVectorYawPitch
extends SimplePropertyExpression<Vector, Number> {
    private int mark;
    private static final String[] type;

    static {
        Skript.registerExpression(ExprVectorYawPitch.class, Number.class, ExpressionType.PROPERTY, "vector (0\u00a6yaw|1\u00a6pitch) of %vector%");
        type = new String[]{"yyaw", "ppitch"};
    }

    @Override
    public Number convert(Vector vector) {
        if (vector != null) {
            switch (this.mark) {
                case 0: {
                    return Float.valueOf(VectorMath.skriptYaw(VectorMath.getYaw(vector)));
                }
                case 1: {
                    return Float.valueOf(VectorMath.skriptPitch(VectorMath.getPitch(vector)));
                }
            }
        }
        return null;
    }

    @Override
    protected String getPropertyName() {
        return String.valueOf(type[this.mark]) + " of vector";
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.mark = parseResult.mark;
        return true;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) && this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, Vector.class)) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        float n = ((Number)delta[0]).floatValue();
        float yaw = VectorMath.getYaw(v);
        float pitch = VectorMath.getPitch(v);
        switch (mode) {
            case REMOVE: {
                n = -n;
            }
            case ADD: {
                if (this.mark == 0) {
                    yaw += n;
                } else if (this.mark == 1) {
                    pitch -= n;
                }
                v = VectorMath.fromYawAndPitch(yaw, pitch);
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case SET: {
                if (this.mark == 0) {
                    yaw = VectorMath.fromSkriptYaw(n);
                } else if (this.mark == 1) {
                    pitch = VectorMath.fromSkriptPitch(n);
                }
                v = VectorMath.fromYawAndPitch(yaw, pitch);
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }
}

