/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Dot product")
@Description(value={"Gets the dot product between two vectors."})
@Examples(value={"set {_v} to {_v2} dot {_v3}"})
@Since(value="2.2-dev28")
public class ExprVectorDotProduct
extends SimpleExpression<Double> {
    private Expression<Vector> first;
    private Expression<Vector> second;

    static {
        Skript.registerExpression(ExprVectorDotProduct.class, Double.class, ExpressionType.SIMPLE, "%vector% dot %vector%");
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return String.valueOf(this.first.toString()) + " dot " + this.second.toString();
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.first = expressions[0];
        this.second = expressions[1];
        return true;
    }

    protected Double[] get(Event event) {
        Vector v1 = this.first.getSingle(event);
        Vector v2 = this.second.getSingle(event);
        if (v1 == null || v2 == null) {
            return null;
        }
        return new Double[]{v1.getX() * v2.getX() + v1.getY() * v2.getY() + v1.getZ() * v2.getZ()};
    }
}

