/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ScriptOptions;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Locally Suppress Warning")
@Description(value={"Suppresses target warnings from the current script."})
@Examples(value={"locally suppress conflict warnings", "suppress the variable save warnings"})
@Since(value="2.3")
public class EffSuppressWarnings
extends Effect {
    private int CONFLICT = 1;
    private int INSTANCE = 2;
    private int CONJUNCTION = 3;
    private int STARTEXPR = 4;
    private int mark = 0;

    static {
        Skript.registerEffect(EffSuppressWarnings.class, "[local[ly]] suppress [the] (1\u00a6conflict|2\u00a6variable save|3\u00a6[missing] conjunction[s]|4\u00a6starting [with] expression[s]) warning[s]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Config cs = ScriptLoader.currentScript;
        if (cs == null) {
            Skript.error("You can only suppress warnings for script files!");
            return false;
        }
        File scriptFile = cs.getFile();
        this.mark = parseResult.mark;
        switch (parseResult.mark) {
            case 1: {
                ScriptOptions.getInstance().setSuppressWarning(scriptFile, "conflict");
                break;
            }
            case 2: {
                ScriptOptions.getInstance().setSuppressWarning(scriptFile, "instance var");
                break;
            }
            case 3: {
                ScriptOptions.getInstance().setSuppressWarning(scriptFile, "conjunction");
                break;
            }
            case 4: {
                ScriptOptions.getInstance().setSuppressWarning(scriptFile, "start expression");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "suppress " + (this.mark == this.CONFLICT ? "conflict" : (this.mark == this.INSTANCE ? "variable save" : (this.mark == this.CONJUNCTION ? "missing conjunction" : (this.mark == this.STARTEXPR ? "starting expression" : "")))) + " warnings";
    }

    @Override
    protected void execute(Event e) {
    }
}

