/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.effects.EffSpawn;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Drop")
@Description(value={"Drops one or more items."})
@Examples(value={"on death of creeper:", "\tdrop 1 TNT"})
@Since(value="1.0")
public class EffDrop
extends Effect {
    @Nullable
    public static Entity lastSpawned;
    private Expression<?> drops;
    private Expression<Location> locations;
    private boolean useVelocity = true;

    static {
        Skript.registerEffect(EffDrop.class, "drop %itemtypes/experience% [%directions% %locations%]", "drop %itemtypes/experience% [%directions% %locations%] without velocity");
        lastSpawned = null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.drops = exprs[0];
        this.locations = Direction.combine(exprs[1], exprs[2]);
        if (matchedPattern == 1) {
            this.useVelocity = false;
        }
        return true;
    }

    @Override
    public void execute(Event e) {
        ?[] os = this.drops.getArray(e);
        if (e instanceof EntityDeathEvent && this.locations.isSingle() && ((EntityDeathEvent)e).getEntity().getLocation().equals((Object)this.locations.getSingle(e)) && !Delay.isDelayed(e)) {
            ?[] objArray = os;
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objArray[n2];
                if (o instanceof Experience) {
                    ((EntityDeathEvent)e).setDroppedExp(((EntityDeathEvent)e).getDroppedExp() + ((Experience)o).getXP());
                } else {
                    ((ItemType)o).addTo(((EntityDeathEvent)e).getDrops());
                }
                ++n2;
            }
            return;
        }
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n3 = 0;
        while (n3 < n) {
            Location l = locationArray[n3];
            Location itemDropLoc = l.clone().subtract(0.5, 0.5, 0.5);
            ?[] objArray = os;
            int n4 = os.length;
            int n5 = 0;
            while (n5 < n4) {
                Object o = objArray[n5];
                if (o instanceof Experience) {
                    ExperienceOrb orb = (ExperienceOrb)l.getWorld().spawn(l, ExperienceOrb.class);
                    orb.setExperience(((Experience)o).getXP());
                    EffSpawn.lastSpawned = orb;
                } else {
                    if (o instanceof ItemStack) {
                        o = new ItemType((ItemStack)o);
                    }
                    for (ItemStack is : ((ItemType)o).getItem().getAll()) {
                        if (is.getType() == Material.AIR) continue;
                        if (this.useVelocity) {
                            lastSpawned = l.getWorld().dropItemNaturally(itemDropLoc, is);
                            continue;
                        }
                        Item item = l.getWorld().dropItem(l, is);
                        item.teleport(l);
                        item.setVelocity(new Vector(0, 0, 0));
                        lastSpawned = item;
                    }
                }
                ++n5;
            }
            ++n3;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "drop " + this.drops.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

