/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import ch.njol.util.Callback;
import ch.njol.util.Closeable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

public class UnresolvedOfflinePlayer
implements OfflinePlayer {
    static LinkedBlockingQueue<UnresolvedOfflinePlayer> toResolve;
    static final Thread resolverThread;
    final String name;
    @Nullable
    OfflinePlayer bukkitOfflinePlayer = null;
    final Callback<Void, OfflinePlayer> callback;

    static {
        resolverThread = Skript.newThread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (toResolve == null) {
                        toResolve = new LinkedBlockingQueue();
                    }
                    try {
                        UnresolvedOfflinePlayer p = toResolve.take();
                        p.bukkitOfflinePlayer = Bukkit.getOfflinePlayer((String)p.name);
                        p.callback.run(p);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        }, "Skript offline player resolver thread (fetches UUIDs from the minecraft servers)");
        resolverThread.start();
        Skript.closeOnDisable(new Closeable(){

            @Override
            public void close() {
                resolverThread.interrupt();
            }
        });
    }

    public UnresolvedOfflinePlayer(String name, Callback<Void, OfflinePlayer> callback) {
        this.name = name;
        this.callback = callback;
        toResolve.add(this);
    }

    public String getName() {
        return this.bukkitOfflinePlayer != null ? this.bukkitOfflinePlayer.getName() : this.name;
    }

    public boolean isOnline() {
        return this.bukkitOfflinePlayer != null ? this.bukkitOfflinePlayer.isOnline() : this.getPlayer() != null;
    }

    @Nullable
    public Player getPlayer() {
        return this.bukkitOfflinePlayer != null ? this.bukkitOfflinePlayer.getPlayer() : Bukkit.getPlayerExact((String)this.name);
    }

    public boolean isOp() {
        return this.bukkitOfflinePlayer.isOp();
    }

    public void setOp(boolean value) {
        this.bukkitOfflinePlayer.setOp(value);
    }

    public UUID getUniqueId() {
        return this.bukkitOfflinePlayer.getUniqueId();
    }

    public Map<String, Object> serialize() {
        return this.bukkitOfflinePlayer.serialize();
    }

    public boolean isBanned() {
        return this.bukkitOfflinePlayer.isBanned();
    }

    public boolean isWhitelisted() {
        return this.bukkitOfflinePlayer.isWhitelisted();
    }

    public void setWhitelisted(boolean value) {
        this.bukkitOfflinePlayer.setWhitelisted(value);
    }

    public long getFirstPlayed() {
        return this.bukkitOfflinePlayer.getFirstPlayed();
    }

    @Deprecated
    public long getLastPlayed() {
        return this.bukkitOfflinePlayer.getLastPlayed();
    }

    public boolean hasPlayedBefore() {
        return this.bukkitOfflinePlayer.hasPlayedBefore();
    }

    public Location getBedSpawnLocation() {
        return this.bukkitOfflinePlayer.getBedSpawnLocation();
    }

    public long getLastLogin() {
        return this.bukkitOfflinePlayer.getLastLogin();
    }

    public long getLastSeen() {
        return this.bukkitOfflinePlayer.getLastSeen();
    }
}

