/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Between locations")
@Description(value={"Creates a vector between two locations."})
@Examples(value={"set {_v} to vector between {_loc1} and {_loc2}"})
@Since(value="2.2-dev28")
public class ExprVectorBetweenLocations
extends SimpleExpression<Vector> {
    private Expression<Location> from;
    private Expression<Location> to;

    static {
        Skript.registerExpression(ExprVectorBetweenLocations.class, Vector.class, ExpressionType.SIMPLE, "vector (from|between) %location% (to|and) %location%");
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "vector from " + this.from.toString() + " to " + this.to.toString();
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.from = expressions[0];
        this.to = expressions[1];
        return true;
    }

    protected Vector[] get(Event event) {
        Location l1 = this.from.getSingle(event);
        Location l2 = this.to.getSingle(event);
        if (l1 == null || l2 == null) {
            return null;
        }
        return new Vector[]{new Vector(l2.getX() - l1.getX(), l2.getY() - l1.getY(), l2.getZ() - l1.getZ())};
    }
}

