/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.NullableChecker;
import ch.njol.util.coll.iterator.ArrayIterator;
import ch.njol.util.coll.iterator.CheckedIterator;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Items")
@Description(value={"Items or blocks of a specific type, useful for looping."})
@Examples(value={"loop items of type ore and log:", "\tblock contains loop-item", "\tmessage \"Theres at least one %loop-item% in this block\"", "drop all blocks at the player # drops one of every block at the player"})
@Since(value="<i>unknown</i> (before 2.1)")
public class ExprItems
extends SimpleExpression<ItemStack> {
    @Nullable
    Expression<ItemType> types = null;
    private boolean blocks = false;
    @Nullable
    private ItemStack[] buffer = null;

    static {
        Skript.registerExpression(ExprItems.class, ItemStack.class, ExpressionType.COMBINED, "[(all [[of] the]|the|every)] item(s|[ ]types)", "[(all [[of] the]|the)] items of type[s] %itemtypes%", "[(all [[of] the]|the|every)] block(s|[ ]types)", "[(all [[of] the]|the)] blocks of type[s] %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (vars.length > 0) {
            this.types = vars[0];
        }
        boolean bl = this.blocks = matchedPattern >= 2;
        if (this.types instanceof Literal) {
            ItemType[] itemTypeArray = (ItemType[])((Literal)this.types).getAll();
            int n = itemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                t.setAll(true);
                ++n2;
            }
        }
        return true;
    }

    protected ItemStack[] get(Event e) {
        if (this.buffer != null) {
            return this.buffer;
        }
        ArrayList<ItemStack> r = new ArrayList<ItemStack>();
        for (ItemStack is : new IteratorIterable<ItemStack>(this.iterator(e))) {
            r.add(is);
        }
        if (this.types instanceof Literal) {
            this.buffer = r.toArray(new ItemStack[r.size()]);
            return this.buffer;
        }
        return r.toArray(new ItemStack[r.size()]);
    }

    @Override
    @Nullable
    public Iterator<ItemStack> iterator(Event e) {
        Iterator<ItemStack> iter;
        if (this.types == null) {
            iter = new Iterator<ItemStack>(){
                private final Iterator<Material> iter = new ArrayIterator<Material>(Material.values());

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public ItemStack next() {
                    return new ItemStack(this.iter.next());
                }

                @Override
                public void remove() {
                }
            };
        } else {
            final ArrayIterator<ItemType> it = new ArrayIterator<ItemType>(this.types.getArray(e));
            if (!it.hasNext()) {
                return null;
            }
            iter = new Iterator<ItemStack>(){
                Iterator<ItemStack> current;
                {
                    this.current = ((ItemType)iterator.next()).getAll().iterator();
                }

                @Override
                public boolean hasNext() {
                    while (!this.current.hasNext() && it.hasNext()) {
                        this.current = ((ItemType)it.next()).getAll().iterator();
                    }
                    return this.current.hasNext();
                }

                @Override
                public ItemStack next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.current.next();
                }

                @Override
                public void remove() {
                }
            };
        }
        if (!this.blocks) {
            return iter;
        }
        return new CheckedIterator<ItemStack>(iter, new NullableChecker<ItemStack>(){

            @Override
            public boolean check(@Nullable ItemStack is) {
                return is != null && is.getType().isBlock();
            }
        });
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<ItemType> types = this.types;
        return String.valueOf(this.blocks ? "blocks" : "items") + (types != null ? " of type" + (types.isSingle() ? "" : "s") + " " + types.toString(e, debug) : "");
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isLoopOf(String s) {
        return this.blocks && s.equalsIgnoreCase("block") || !this.blocks && s.equalsIgnoreCase("item");
    }
}

