/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.DroppedItemSlot;
import ch.njol.skript.util.slot.ItemFrameSlot;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item of an Entity")
@Description(value={"An item associated with an entity. For dropped item entities, it gets, obviously, the item that was dropped. For item frames, the item inside the frame is returned. Other entities do not have items associated with them."})
@Examples(value={""})
@Since(value="2.2-dev35, 2.2-dev36 (improved)")
public class ExprItemFrameSlot
extends SimplePropertyExpression<Entity, Slot> {
    static {
        ExprItemFrameSlot.register(ExprItemFrameSlot.class, Slot.class, "item", "entities");
    }

    @Override
    @Nullable
    public Slot convert(Entity e) {
        if (e instanceof ItemFrame) {
            return new ItemFrameSlot((ItemFrame)e);
        }
        if (e instanceof Item) {
            return new DroppedItemSlot((Item)e);
        }
        return null;
    }

    @Override
    protected String getPropertyName() {
        return "item of entity";
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }
}

