/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.Kleenean;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Action Bar")
@Description(value={"Sends an action bar message to the given player(s)."})
@Examples(value={"send action bar \"Hello player!\" to player"})
@Since(value="2.3")
public class EffActionBar
extends Effect {
    private Expression<String> message;
    private Expression<Player> recipients;

    static {
        Skript.registerEffect(EffActionBar.class, "send [the] action bar [with text] %string% to %players%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.message = exprs[0];
        this.recipients = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String msg = this.message.getSingle(e);
        assert (msg != null);
        Player[] playerArray = this.recipients.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, BungeeConverter.convert(ChatMessages.parseToArray(msg)));
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "send action bar " + this.message.toString(e, debug) + " to " + this.recipients.toString(e, debug);
    }
}

