/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;

public class EnumParser<E extends Enum<E>>
implements Converter<String, E> {
    private final Class<E> enumType;
    @Nullable
    private final String allowedValues;
    private final String type;

    public EnumParser(Class<E> enumType, String type) {
        assert (enumType != null);
        this.enumType = enumType;
        this.type = type;
        if (((Enum[])enumType.getEnumConstants()).length <= 12) {
            StringBuilder b = new StringBuilder(((Enum[])enumType.getEnumConstants())[0].name());
            Enum[] enumArray = (Enum[])enumType.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(e.name().toLowerCase(Locale.ENGLISH).replace('_', ' '));
                ++n2;
            }
            this.allowedValues = b.toString();
        } else {
            this.allowedValues = null;
        }
    }

    @Override
    @Nullable
    public E convert(String s) {
        try {
            return Enum.valueOf(this.enumType, s.toUpperCase(Locale.ENGLISH).replace(' ', '_'));
        }
        catch (IllegalArgumentException e) {
            Skript.error("'" + s + "' is not a valid value for " + this.type + (this.allowedValues == null ? "" : ". Allowed values are: " + this.allowedValues));
            return null;
        }
    }
}

