/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffectType;

@Name(value="Is Poisoned")
@Description(value={"Checks whether an entity is poisoned."})
@Examples(value={"player is poisoned:", "\tcure the player from poison", "\tmessage \"You have been cured!\""})
@Since(value="1.4.4")
public class CondIsPoisoned
extends PropertyCondition<LivingEntity> {
    static {
        CondIsPoisoned.register(CondIsPoisoned.class, "poisoned", "livingentities");
    }

    @Override
    public boolean check(LivingEntity e) {
        return e.hasPotionEffect(PotionEffectType.POISON);
    }

    @Override
    protected String getPropertyName() {
        return "poisoned";
    }
}

