/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;

@Name(value="Is Alive")
@Description(value={"Checks whether an entity is alive. This is mostly useful to check whether an entity stored in a variable does still exist."})
@Examples(value={"{villager-buddy::%player's uuid%} is dead"})
@Since(value="2.0")
public class CondIsAlive
extends PropertyCondition<LivingEntity> {
    private boolean alive;

    static {
        CondIsAlive.register(CondIsAlive.class, "(1\u00a6alive|0\u00a6dead)", "livingentities");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.alive = parseResult.mark == 1;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public boolean check(LivingEntity e) {
        return this.alive ^ e.isDead();
    }

    @Override
    protected String getPropertyName() {
        return this.alive ? "alive" : "dead";
    }
}

