/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.UnparsedLiteral;
import java.util.stream.Stream;

public class LiteralUtils {
    public static <T> Expression<T> defendExpression(Expression<?> expr) {
        if (expr instanceof ExpressionList) {
            Expression<T>[] expressions = ((ExpressionList)expr).getExpressions();
            int i = 0;
            while (i < expressions.length) {
                expressions[i] = LiteralUtils.defendExpression(expressions[i]);
                ++i;
            }
        } else if (expr instanceof UnparsedLiteral) {
            Expression parsedLiteral = ((UnparsedLiteral)expr).getConvertedExpression(new Class[]{Object.class});
            return parsedLiteral == null ? expr : parsedLiteral;
        }
        return expr;
    }

    public static boolean hasUnparsedLiteral(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) {
            return true;
        }
        if (expr instanceof ExpressionList) {
            return Stream.of(((ExpressionList)expr).getExpressions()).anyMatch(e -> e instanceof UnparsedLiteral);
        }
        return false;
    }

    public static boolean canInitSafely(Expression<?> ... expressions) {
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] == null || LiteralUtils.hasUnparsedLiteral(expressions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

