/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BlockUtils {
    private static final BlockFace[] bed = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
    private static final BlockFace[] gate = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH};

    public static boolean set(Block block, ItemData type, boolean applyPhysics) {
        int flags = 13;
        if (applyPhysics) {
            flags |= 0x10;
        }
        BlockCompat.SETTER.setBlock(block, type.getType(), type.getBlockValues(), flags);
        return true;
    }

    public static Iterable<Block> getBlocksAround(Block b) {
        return Arrays.asList(b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.SOUTH), b.getRelative(BlockFace.WEST));
    }

    public static Iterable<BlockFace> getFaces() {
        return Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }

    @Nullable
    public static Location getLocation(@Nullable Block b) {
        if (b == null) {
            return null;
        }
        Location l = b.getLocation().add(0.5, 0.5, 0.5);
        return l;
    }
}

