/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public abstract class TriggerSection
extends TriggerItem {
    @Nullable
    private TriggerItem first = null;
    @Nullable
    protected TriggerItem last = null;

    protected TriggerSection(List<TriggerItem> items) {
        this.setTriggerItems(items);
    }

    protected TriggerSection(SectionNode node) {
        ScriptLoader.currentSections.add(this);
        try {
            this.setTriggerItems(ScriptLoader.loadItems(node));
        }
        finally {
            ScriptLoader.currentSections.remove(ScriptLoader.currentSections.size() - 1);
        }
    }

    protected TriggerSection() {
    }

    protected void setTriggerItems(List<TriggerItem> items) {
        if (!items.isEmpty()) {
            this.first = items.get(0);
            this.last = items.get(items.size() - 1);
            this.last.setNext(this.getNext());
        }
        for (TriggerItem item : items) {
            item.setParent(this);
        }
    }

    @Override
    public TriggerSection setNext(@Nullable TriggerItem next) {
        super.setNext(next);
        if (this.last != null) {
            this.last.setNext(next);
        }
        return this;
    }

    @Override
    public TriggerSection setParent(@Nullable TriggerSection parent) {
        super.setParent(parent);
        return this;
    }

    @Override
    protected final boolean run(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    protected abstract TriggerItem walk(Event var1);

    @Nullable
    protected final TriggerItem walk(Event e, boolean run) {
        this.debug(e, run);
        if (run && this.first != null) {
            return this.first;
        }
        return this.getNext();
    }
}

