/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Book Pages")
@Description(value={"The pages of a book."})
@Examples(value={"on book sign:", "\tmessage \"Book Pages: %pages of event-item%\"", "\tmessage \"Book Page 1: %page 1 of event-item%\""})
@Since(value="2.2-dev31")
public class ExprBookPages
extends SimpleExpression<String> {
    private static final ItemType bookItem;
    private Expression<ItemStack> book;
    @Nullable
    private Expression<Number> page;

    static {
        Skript.registerExpression(ExprBookPages.class, String.class, ExpressionType.PROPERTY, "[all] [the] [book] (pages|content) of %itemstack%", "%itemstack%'s [book] (pages|content)", "[book] page %number% of %itemstack%", "%itemstack%'s [book] page %number%");
        bookItem = Aliases.javaItemType("book with text");
    }

    @Nullable
    protected String[] get(Event e) {
        ItemStack itemStack = this.book.getSingle(e);
        if (itemStack == null || !bookItem.isOfType(itemStack)) {
            return null;
        }
        List pages = ((BookMeta)itemStack.getItemMeta()).getPages();
        if (this.page != null) {
            Number pageNumber = this.page.getSingle(e);
            if (pageNumber == null) {
                return null;
            }
            int page = pageNumber.intValue();
            if (page > pages.size() || page < 1) {
                return null;
            }
            return new String[]{(String)pages.get(page - 1)};
        }
        return pages.toArray(new String[pages.size()]);
    }

    @Override
    public boolean isSingle() {
        return this.page != null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "book pages of " + this.book.toString(e, debug);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0 || matchedPattern == 1) {
            this.book = exprs[0];
        } else if (matchedPattern == 2) {
            this.page = exprs[0];
            this.book = exprs[1];
        } else {
            this.book = exprs[0];
            this.page = exprs[1];
        }
        return true;
    }
}

