/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtCommand
extends SkriptEvent {
    @Nullable
    private String command = null;

    static {
        Skript.registerEvent("Command", EvtCommand.class, CollectionUtils.array(PlayerCommandPreprocessEvent.class, ServerCommandEvent.class), "command [%-string%]").description("Called when a player enters a command (not neccessarily a Skript command).").examples("on command:", "on command \"/stop\":", "on command \"pm Njol \":").since("2.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (args[0] != null) {
            this.command = (String)args[0].getSingle();
            if (this.command.startsWith("/")) {
                this.command = this.command.substring(1);
            }
        }
        return true;
    }

    @Override
    public boolean check(Event e) {
        String message;
        if (this.command == null) {
            return true;
        }
        if (e instanceof PlayerCommandPreprocessEvent) {
            assert (((PlayerCommandPreprocessEvent)e).getMessage().startsWith("/"));
            message = ((PlayerCommandPreprocessEvent)e).getMessage().substring(1);
        } else {
            message = ((ServerCommandEvent)e).getCommand();
        }
        return StringUtils.startsWithIgnoreCase(message, this.command) && (this.command.contains(" ") || message.length() == this.command.length() || Character.isWhitespace(message.charAt(this.command.length())));
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "command" + (this.command != null ? " /" + this.command : "");
    }
}

