/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.ProjectileUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Shoot")
@Description(value={"Shoots a projectile (or any other entity) from a given entity."})
@Examples(value={"shoot an arrow", "make the player shoot a creeper at speed 10", "shoot a pig from the creeper"})
@Since(value="1.4")
public class EffShoot
extends Effect {
    private static final Double DEFAULT_SPEED;
    private Expression<EntityData<?>> types;
    private Expression<?> shooters;
    @Nullable
    private Expression<Number> velocity;
    @Nullable
    private Expression<Direction> direction;
    @Nullable
    public static Entity lastSpawned;

    static {
        Skript.registerEffect(EffShoot.class, "shoot %entitydatas% [from %livingentities/locations%] [(at|with) (speed|velocity) %-number%] [%-direction%]", "(make|let) %livingentities/locations% shoot %entitydatas% [(at|with) (speed|velocity) %-number%] [%-direction%]");
        DEFAULT_SPEED = 5.0;
        lastSpawned = null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[matchedPattern];
        this.shooters = exprs[1 - matchedPattern];
        this.velocity = exprs[2];
        this.direction = exprs[3];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Direction dir;
        Double v;
        lastSpawned = null;
        Number number = v = this.velocity != null ? (Number)this.velocity.getSingle(e) : (Number)DEFAULT_SPEED;
        if (v == null) {
            return;
        }
        Direction direction = dir = this.direction != null ? this.direction.getSingle(e) : Direction.IDENTITY;
        if (dir == null) {
            return;
        }
        ?[] objArray = this.shooters.getArray(e);
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object shooter = objArray[n2];
            EntityData<?>[] entityDataArray = this.types.getArray(e);
            int n3 = entityDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Vector vel;
                EntityData<?> d = entityDataArray[n4];
                if (shooter instanceof LivingEntity) {
                    Projectile projectile;
                    vel = dir.getDirection(((LivingEntity)shooter).getLocation()).multiply(((Number)v).doubleValue());
                    Class<?> type = d.getType();
                    if (Fireball.class.isAssignableFrom(type)) {
                        projectile = (Fireball)((LivingEntity)shooter).getWorld().spawn(((LivingEntity)shooter).getEyeLocation().add(vel.clone().normalize().multiply(0.5)), type);
                        ProjectileUtils.setShooter(projectile, shooter);
                        projectile.setVelocity(vel);
                        lastSpawned = projectile;
                    } else if (Projectile.class.isAssignableFrom(type)) {
                        projectile = ((LivingEntity)shooter).launchProjectile(type);
                        EffShoot.set((Entity)projectile, d);
                        projectile.setVelocity(vel);
                        lastSpawned = projectile;
                    } else {
                        Location loc = ((LivingEntity)shooter).getLocation();
                        loc.setY(loc.getY() + ((LivingEntity)shooter).getEyeHeight() / 2.0);
                        Object projectile2 = d.spawn(loc);
                        if (projectile2 != null) {
                            projectile2.setVelocity(vel);
                        }
                        lastSpawned = projectile2;
                    }
                } else {
                    vel = dir.getDirection((Location)shooter).multiply(((Number)v).doubleValue());
                    Object projectile = d.spawn((Location)shooter);
                    if (projectile != null) {
                        projectile.setVelocity(vel);
                    }
                    lastSpawned = projectile;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static <E extends Entity> void set(Entity e, EntityData<E> d) {
        d.set(e);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "shoot " + this.types.toString(e, debug) + " from " + this.shooters.toString(e, debug) + (this.velocity != null ? " at speed " + this.velocity.toString(e, debug) : "") + (this.direction != null ? " " + this.direction.toString(e, debug) : "");
    }
}

