/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is in World")
@Description(value={"Checks whether an entity is in a specific world."})
@Examples(value={"player is in \"world\"", "argument isn't in world \"world_nether\"", "the player is in the world of the victim"})
@Since(value="1.4")
public class CondIsInWorld
extends Condition {
    private Expression<Entity> entities;
    private Expression<World> worlds;

    static {
        PropertyCondition.register(CondIsInWorld.class, "in [[the] world[s]] %worlds%", "entities");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.worlds = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.entities.check(e, entity -> this.worlds.check(e, world -> entity.getWorld() == world), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.BE, e, debug, this.entities, "in the " + (this.worlds.isSingle() ? "world " : "worlds ") + this.worlds.toString(e, debug));
    }
}

